/*
 * Decompiled with CFR 0.152.
 */
package cyberslas.pathundergates.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.modlauncher.api.INameMappingService;
import cyberslas.pathundergates.Config;
import cyberslas.pathundergates.PathUnderGates;
import cyberslas.pathundergates.util.DomainNamePair;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ParsedConfig {
    private static Multimap<DomainNamePair, List<String>> whitelistMap = HashMultimap.create();
    private static Multimap<DomainNamePair, List<String>> blacklistMap = HashMultimap.create();
    private static final Map<Block, BlockState> modAddedBlockPathMap = new HashMap<Block, BlockState>();
    private static final String FLATTENABLESFIELDSRG = "f_43110_";
    private static final Map<Block, BlockState> CACHEDFLATTENABLES;
    private static final Map<Block, BlockState> FLATTENABLESFIELD;

    public static void addBlockPathMapping(Block block, BlockState blockState) {
        modAddedBlockPathMap.put(block, blockState);
    }

    public static void parseConfig() {
        FLATTENABLESFIELD.clear();
        FLATTENABLESFIELD.putAll(CACHEDFLATTENABLES);
        whitelistMap = ConfigParser.processListIntoMap((List)Config.SERVER.blocksWhitelist.get());
        blacklistMap = ConfigParser.processListIntoMap((List)Config.SERVER.blocksBlacklist.get());
        Map<Block, BlockState> blockPathMap = ConfigParser.processBlockPathPairListIntoMap((List)Config.SERVER.blockPathList.get());
        blockPathMap.putAll(modAddedBlockPathMap);
        FLATTENABLESFIELD.putAll(blockPathMap);
    }

    public static boolean matchesBlockWhitelist(BlockState blockState) {
        return ParsedConfig.matchesBlockMap(blockState, whitelistMap);
    }

    public static boolean matchesBlockBlacklist(BlockState blockState) {
        return ParsedConfig.matchesBlockMap(blockState, blacklistMap);
    }

    private static boolean matchesBlockMap(BlockState blockState, Multimap<DomainNamePair, List<String>> map) {
        DomainNamePair blockDomainNamePair = new DomainNamePair(blockState.m_60734_().getRegistryName());
        if (!map.containsKey((Object)blockDomainNamePair)) {
            blockDomainNamePair = new DomainNamePair(blockDomainNamePair.getDomain(), "*");
            return map.containsKey((Object)blockDomainNamePair);
        }
        for (List propertyList : map.get((Object)blockDomainNamePair)) {
            if (!((String)propertyList.get(0)).contains("=")) {
                if (!((String)propertyList.get(0)).equals("*")) continue;
                return true;
            }
            Map<String, String> propertyMap = propertyList.stream().map(input -> input.split("=")).collect(Collectors.toMap(v -> v[0], v -> v[1]));
            for (Property blockStateProperty : blockState.m_61147_()) {
                if (!propertyMap.containsKey(blockStateProperty.m_61708_()) || propertyMap.get(blockStateProperty.m_61708_()).equals(blockState.m_61143_(blockStateProperty).toString())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        Field field = ObfuscationReflectionHelper.findField(ShovelItem.class, (String)FLATTENABLESFIELDSRG);
        Map temp = new HashMap();
        try {
            temp = (Map)field.get(null);
        }
        catch (Exception e) {
            PathUnderGates.logger.error("Failed to reflect field " + ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)FLATTENABLESFIELDSRG) + ", options defined in blockPathPairList will not work");
        }
        FLATTENABLESFIELD = temp;
        CACHEDFLATTENABLES = new HashMap<Block, BlockState>(FLATTENABLESFIELD);
    }

    private static class ConfigParser {
        private static final String WILDCARD = "*";
        private static final String TAGSTART = "#";
        private static final String OREDOMAIN = "ore";
        private static final List<String> DEFAULTTAGDOMAINS = Arrays.asList("minecraft", "forge");
        private static final String DOMAINSEPARATOR = ":";
        private static final String PROPERTYSEPARATOR = ",";
        private static final String PROPERTYKEYVALUESEPARATOR = "=";
        private static final String PAIRSEPARATOR = "\\|";
        private static final Block BADBLOCK = Blocks.f_50016_;
        private static final BlockState BADBLOCKSTATE = BADBLOCK.m_49966_();

        private ConfigParser() {
        }

        private static Multimap<DomainNamePair, List<String>> processListIntoMap(List<? extends String> list) {
            HashMultimap multimap = HashMultimap.create();
            for (String string : list) {
                ImmutablePair<String, String> domainAndBlockState = ConfigParser.splitAtDomainSeparator(string);
                ImmutablePair<String, String> blockNameAndState = ConfigParser.splitAtDomainSeparator((String)domainAndBlockState.getRight());
                String domain = (String)domainAndBlockState.getLeft();
                String name = (String)blockNameAndState.getLeft();
                String state = (String)blockNameAndState.getRight();
                boolean tagHint = false;
                if (domain.startsWith(TAGSTART)) {
                    domain = domain.substring(TAGSTART.length());
                    tagHint = true;
                }
                if (state.equals(WILDCARD)) {
                    List<String> domainsToCheck;
                    HashSet blockSet = new HashSet();
                    if (domain.equals(OREDOMAIN)) {
                        domainsToCheck = DEFAULTTAGDOMAINS;
                        tagHint = true;
                    } else {
                        domainsToCheck = Collections.singletonList(domain);
                    }
                    domainsToCheck.stream().map(domainToCheck -> ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation(domainToCheck, name)))).forEach(tag -> blockSet.addAll(tag.stream().toList()));
                    if (blockSet.size() > 0) {
                        for (Block block : blockSet) {
                            multimap.put((Object)new DomainNamePair(block.getRegistryName()), Collections.singletonList(state));
                        }
                        continue;
                    }
                    if (tagHint) continue;
                    multimap.put((Object)new DomainNamePair(domain, name), Collections.singletonList(state));
                    continue;
                }
                DomainNamePair domainNamePair = new DomainNamePair(domain, name);
                List<String> propertiesList = ConfigParser.processStateIntoPropertiesList(state);
                multimap.put((Object)domainNamePair, propertiesList);
            }
            return multimap;
        }

        private static Map<Block, BlockState> processBlockPathPairListIntoMap(List<? extends String> list) {
            HashMap<Block, BlockState> map = new HashMap<Block, BlockState>();
            for (String string : list) {
                BlockState blockState;
                String[] splitPair = string.split(PAIRSEPARATOR);
                Block block = ConfigParser.blockStateEntryToBlock(ConfigParser.splitAtDomainSeparator(splitPair[0]));
                if (block.equals(BADBLOCK) || (blockState = ConfigParser.blockStateEntryToBlockstate(ConfigParser.splitAtDomainSeparator(splitPair[1]))).equals(BADBLOCKSTATE)) continue;
                map.put(block, blockState);
            }
            return map;
        }

        private static Block blockStateEntryToBlock(ImmutablePair<String, String> entry) {
            String name;
            ImmutablePair<String, String> blockNameAndState = ConfigParser.splitAtDomainSeparator((String)entry.getRight());
            String domain = (String)entry.getLeft();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(domain, name = (String)blockNameAndState.getLeft()));
            if (block == null) {
                block = BADBLOCK;
            }
            return block;
        }

        private static BlockState blockStateEntryToBlockstate(ImmutablePair<String, String> entry) {
            Block block = ConfigParser.blockStateEntryToBlock(entry);
            if (block.equals(BADBLOCK)) {
                return BADBLOCKSTATE;
            }
            String state = (String)ConfigParser.splitAtDomainSeparator((String)entry.getRight()).getRight();
            List<String> propertiesList = ConfigParser.processStateIntoPropertiesList(state);
            BlockState blockState = block.m_49966_();
            if (!propertiesList.get(0).contains(PROPERTYKEYVALUESEPARATOR)) {
                return blockState;
            }
            Map<String, String> propertyMap = propertiesList.stream().map(input -> input.split(PROPERTYKEYVALUESEPARATOR)).collect(Collectors.toMap(v -> v[0], v -> v[1]));
            for (Property blockStateProperty : blockState.m_61147_()) {
                if (!propertyMap.containsKey(blockStateProperty.m_61708_())) continue;
                blockState = ConfigParser.newBlockStateWithProperty(blockState, blockStateProperty, propertyMap.get(blockStateProperty.m_61708_()));
            }
            return blockState;
        }

        private static <T extends Comparable<T>> BlockState newBlockStateWithProperty(BlockState state, Property<T> property, String stringValue) {
            Optional value = property.m_6215_(stringValue);
            return value.map(t -> (BlockState)state.m_61124_(property, t)).orElse(state);
        }

        private static ImmutablePair<String, String> splitAtDomainSeparator(String entry) {
            String[] splitPair = entry.split(DOMAINSEPARATOR, 2);
            if (splitPair.length == 1) {
                return ImmutablePair.of((Object)splitPair[0], (Object)WILDCARD);
            }
            return ImmutablePair.of((Object)splitPair[0], (Object)splitPair[1]);
        }

        private static List<String> processStateIntoPropertiesList(String properties) {
            return Arrays.asList(properties.split(PROPERTYSEPARATOR));
        }
    }
}

