/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.time;

import com.mlib.Utility;
import com.mlib.contexts.OnServerTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Priority;
import com.mlib.modhelper.AutoInstance;
import com.mlib.time.Delay;
import com.mlib.time.ISuspendedExecution;
import com.mlib.time.Slider;
import com.mlib.time.Until;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Time {
    static final List<ISuspendedExecution> PENDING_EXECUTIONS = Collections.synchronizedList(new ArrayList());
    static final List<ISuspendedExecution> EXECUTIONS = Collections.synchronizedList(new ArrayList());

    public static Delay delay(int ticks, Consumer<Delay> callback) {
        return Time.setup(new Delay(callback, ticks));
    }

    public static Delay delay(double seconds, Consumer<Delay> callback) {
        return Time.delay(Utility.secondsToTicks(seconds), callback);
    }

    public static Delay nextTick(Runnable callback) {
        return Time.delay(1, (Delay delay) -> callback.run());
    }

    public static Slider slider(int ticks, Consumer<Slider> callback) {
        return Time.setup(new Slider(callback, ticks));
    }

    public static Slider slider(double seconds, Consumer<Slider> callback) {
        return Time.slider(Utility.secondsToTicks(seconds), callback);
    }

    public static Until until(Supplier<Boolean> isReady, Consumer<Until> callback) {
        return Time.setup(new Until(callback, isReady));
    }

    public static <Type extends ISuspendedExecution> Type setup(Type exec) {
        PENDING_EXECUTIONS.add(exec);
        return exec;
    }

    @AutoInstance
    public static class Updater {
        public Updater() {
            OnServerTick.listen(this::updateExecs).priority(Priority.HIGHEST).addCondition(Condition.isEndPhase());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateExecs(OnServerTick.Data data) {
            List<ISuspendedExecution> list = PENDING_EXECUTIONS;
            synchronized (list) {
                PENDING_EXECUTIONS.forEach(ISuspendedExecution::onStart);
                EXECUTIONS.addAll(PENDING_EXECUTIONS);
                PENDING_EXECUTIONS.clear();
            }
            Iterator<ISuspendedExecution> iterator = EXECUTIONS.iterator();
            while (iterator.hasNext()) {
                ISuspendedExecution exec = iterator.next();
                exec.onTick();
                if (!exec.isFinished()) continue;
                exec.onEnd();
                iterator.remove();
            }
        }
    }
}

