/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.mixin;

import com.mlib.Random;
import com.mlib.contexts.OnMobSpawnRate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
public abstract class MixinNaturalSpawner {
    @Shadow(aliases={"this$0"})
    @Inject(method={"spawnCategoryForChunk (Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void spawnCategoryForChunk(MobCategory category, ServerLevel level, LevelChunk chunk, NaturalSpawner.SpawnPredicate predicate, NaturalSpawner.AfterSpawnCallback spawnCallback, CallbackInfo callbackInfo) {
        int extraMobsCount = Random.round(OnMobSpawnRate.dispatch(category, level, chunk).getSpawnRate() - 1.0f);
        for (int idx = 0; idx < extraMobsCount; ++idx) {
            NaturalSpawner.m_47038_((MobCategory)category, (ServerLevel)level, (ChunkAccess)chunk, (BlockPos)MixinNaturalSpawner.getRandomSpawnPos(level, chunk), (NaturalSpawner.SpawnPredicate)predicate, (NaturalSpawner.AfterSpawnCallback)spawnCallback);
        }
    }

    private static BlockPos getRandomSpawnPos(ServerLevel level, LevelChunk chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        int x = chunkpos.m_45604_() + Random.nextInt(16);
        int z = chunkpos.m_45605_() + Random.nextInt(16);
        int y = Random.nextInt(level.m_141937_(), chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z) + 1);
        return new BlockPos(x, y, z);
    }
}

