/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.features;

import com.mlib.Random;
import com.mlib.contexts.OnExtraFishingLootCheck;
import com.mlib.contexts.OnItemFished;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Priority;
import com.mlib.entities.EntityHelper;
import com.mlib.math.AnyPos;
import com.mlib.modhelper.AutoInstance;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class FishingLootIncreaser {
    public FishingLootIncreaser() {
        OnItemFished.listen(this::increaseLoot).priority(Priority.HIGHEST).addCondition(Condition.isServer());
    }

    private void increaseLoot(OnItemFished.Data data) {
        OnExtraFishingLootCheck.Data extraData = OnExtraFishingLootCheck.dispatch(data.event);
        if (extraData.extraLoot.isEmpty()) {
            return;
        }
        this.spawnLoot(data, extraData.extraLoot);
        this.spawnExperience(data, extraData.extraExperience);
        this.damageFishingRod(data, extraData.extraRodDamage);
    }

    private void spawnLoot(OnItemFished.Data data, List<ItemStack> extraLoot) {
        extraLoot.forEach(itemStack -> {
            Vec3 spawnPosition = AnyPos.from(data.hook.m_20182_()).add(Random.nextVector(-0.25, 0.25, 0.125, 0.5, -0.25, 0.25)).vec3();
            ItemEntity itemEntity = new ItemEntity(data.getLevel(), spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, itemStack);
            Vec3 motion = data.player.m_20182_().m_82546_(itemEntity.m_20182_()).m_82542_(0.1, 0.1, 0.1);
            itemEntity.m_20256_(motion.m_82520_(0.0, Math.pow(AnyPos.from(motion).len().doubleValue(), 0.5) * 0.25, 0.0));
            data.getLevel().m_7967_((Entity)itemEntity);
        });
    }

    private void spawnExperience(OnItemFished.Data data, int experience) {
        if (experience > 0) {
            EntityHelper.spawnExperience(data.getLevel(), AnyPos.from(data.player.m_20182_()).add(0.5).vec3(), experience);
        }
    }

    private void damageFishingRod(OnItemFished.Data data, int damage) {
        data.event.damageRodBy(data.event.getRodDamage() + damage);
    }
}

