/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mlib.data.IReader;
import com.mlib.data.ISerializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

record DataMap<Type>(Getter<Type> getter, Setter<Type> setter, IReader<Type> reader) implements ISerializable
{
    @Override
    public void read(JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        HashMap<String, Type> values = new HashMap<String, Type>();
        for (String key : jsonObject.keySet()) {
            values.put(key, this.reader.read(jsonObject.get(key)));
        }
        this.setter.accept(values);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        Map values = (Map)this.getter.get();
        buffer.m_130130_(values.size());
        for (String key : values.keySet()) {
            buffer.m_130070_(key);
            this.reader.write(buffer, values.get(key));
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        HashMap<String, Type> values = new HashMap<String, Type>();
        int size = buffer.m_130242_();
        for (int idx = 0; idx < size; ++idx) {
            String key = buffer.m_130277_();
            values.put(key, this.reader.read(buffer));
        }
        this.setter.accept(values);
    }

    @Override
    public void write(Tag tag) {
        CompoundTag compoundTag = (CompoundTag)tag;
        Map values = (Map)this.getter.get();
        for (String key : values.keySet()) {
            compoundTag.m_128365_(key, this.reader.write(values.get(key)));
        }
    }

    @Override
    public void read(Tag tag) {
        CompoundTag compoundTag = (CompoundTag)tag;
        HashMap<String, Type> values = new HashMap<String, Type>();
        for (String key : compoundTag.m_128431_()) {
            values.put(key, this.reader.read(compoundTag.m_128423_(key)));
        }
        this.setter.accept(values);
    }

    public static interface Getter<Type>
    extends Supplier<Map<String, Type>> {
    }

    public static interface Setter<Type>
    extends Consumer<Map<String, Type>> {
    }
}

