/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts.base;

import com.mlib.Utility;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Priority;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class Contexts<DataType> {
    static final Map<Class<?>, Contexts<?>> CONTEXTS = Collections.synchronizedMap(new HashMap());
    final List<Context<DataType>> contexts = new ArrayList<Context<DataType>>();
    boolean isSorted = true;

    private Contexts() {
    }

    public static <DataType> Contexts<DataType> get(Class<DataType> clazz) {
        return CONTEXTS.computeIfAbsent(clazz, key -> new Contexts());
    }

    public static Stream<Contexts<?>> get() {
        return CONTEXTS.values().stream();
    }

    public synchronized Context<DataType> add(Consumer<DataType> consumer) {
        Context<DataType> context = new Context<DataType>(consumer);
        this.contexts.add(context);
        this.isSorted = false;
        return context;
    }

    public DataType dispatch(DataType data) {
        Utility.profile(data.getClass().getName(), () -> {
            this.tryToSort();
            this.forEach(context -> Utility.profile(context.getProfilerName(), () -> context.accept(data)));
        });
        return data;
    }

    public void forEach(Consumer<Context<DataType>> consumer) {
        this.contexts.forEach(consumer);
    }

    public synchronized void tryToSort() {
        if (!this.isSorted) {
            this.contexts.sort((left, right) -> Priority.COMPARATOR.compare(left.priority, right.priority));
            this.contexts.forEach(Context::tryToSort);
            this.isSorted = true;
        }
    }
}

