/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts;

import com.mlib.Utility;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Contexts;
import com.mlib.contexts.data.ILevelData;
import com.mlib.contexts.data.IPositionData;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class OnProjectileHit {
    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    public static Data dispatch(Projectile projectile, @Nullable ItemStack weapon, @Nullable ItemStack arrow, CompoundTag customTag, HitResult hitResult) {
        return Contexts.get(Data.class).dispatch(new Data(projectile, weapon, arrow, customTag, hitResult));
    }

    public static class Data
    implements ILevelData,
    IPositionData {
        public final Projectile projectile;
        public final Level level;
        @Nullable
        public final Entity owner;
        @Nullable
        public final ItemStack weapon;
        @Nullable
        public final ItemStack arrow;
        public final CompoundTag customTag;
        public final HitResult hitResult;

        public Data(Projectile projectile, @Nullable ItemStack weapon, @Nullable ItemStack arrow, CompoundTag customTag, HitResult hitResult) {
            this.projectile = projectile;
            this.level = projectile.f_19853_;
            this.owner = projectile.m_37282_();
            this.weapon = weapon;
            this.arrow = arrow;
            this.customTag = customTag;
            this.hitResult = hitResult;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public Vec3 getPosition() {
            return this.projectile.m_20318_(0.0f);
        }

        @Nullable
        public EntityHitResult getEntityHitResult() {
            return Utility.castIfPossible(EntityHitResult.class, this.hitResult);
        }

        @Nullable
        public BlockHitResult getBlockHitResult() {
            return Utility.castIfPossible(BlockHitResult.class, this.hitResult);
        }
    }
}

