/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts;

import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Contexts;
import com.mlib.contexts.data.ILevelData;
import com.mlib.contexts.data.IPositionData;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;

@Mod.EventBusSubscriber
public class OnExplosionStart {
    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        Data data = Contexts.get(Data.class).dispatch(new Data(event));
        OnExplosionStart.updateEvent(data);
    }

    private static void updateEvent(Data data) {
        Level level;
        if ((double)(data.radius.getValue().floatValue() - data.explosion.f_46017_) < 1.0 || !((level = data.getLevel()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        data.explosion.f_46017_ = data.radius.getValue().floatValue();
        data.explosion.f_46009_ = data.causesFire.getValue();
        double x = data.explosion.getPosition().f_82479_;
        double y = data.explosion.getPosition().f_82480_;
        double z = data.explosion.getPosition().f_82481_;
        for (ServerPlayer player : level2.m_6907_()) {
            if (!(player.m_20275_(x, y, z) < 4096.0)) continue;
            player.f_8906_.m_141995_((Packet)new ClientboundExplodePacket(x, y, z, data.explosion.f_46017_, data.explosion.m_46081_(), (Vec3)data.explosion.m_46078_().get(player)));
        }
    }

    public static class Data
    implements ILevelData,
    IPositionData {
        public final ExplosionEvent.Start event;
        public final Explosion explosion;
        @Nullable
        public final LivingEntity sourceMob;
        public final MutableFloat radius;
        public final MutableBoolean causesFire;

        public Data(ExplosionEvent.Start event) {
            this.event = event;
            this.explosion = event.getExplosion();
            this.sourceMob = this.explosion.m_46079_();
            this.radius = new MutableFloat(this.explosion.f_46017_);
            this.causesFire = new MutableBoolean(this.explosion.f_46009_);
        }

        @Override
        public Level getLevel() {
            return this.event.getWorld();
        }

        @Override
        public Vec3 getPosition() {
            return this.explosion.getPosition();
        }
    }
}

