/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts;

import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Contexts;
import com.mlib.contexts.data.ILevelData;
import com.mlib.contexts.data.IPositionData;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnExplosionSizeCheck {
    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start explosionEvent) {
        Level level = explosionEvent.getWorld();
        Explosion explosion = explosionEvent.getExplosion();
        Data data = Contexts.get(Data.class).dispatch(new Data(level, explosion));
        if ((double)(data.size / explosion.f_46017_) > 1.25 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            OnExplosionSizeCheck.sendToPlayers(serverLevel, explosion, explosion.getPosition(), data.size);
        }
        explosion.f_46017_ = data.size;
        explosion.f_46009_ = data.causesFire;
    }

    private static void sendToPlayers(ServerLevel level, Explosion explosion, Vec3 position, float size) {
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        for (ServerPlayer player : level.m_6907_()) {
            if (!(player.m_20275_(x, y, z) < 4096.0)) continue;
            player.f_8906_.m_141995_((Packet)new ClientboundExplodePacket(x, y, z, size, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }

    public static class Data
    implements ILevelData,
    IPositionData {
        public final Level level;
        public final Explosion explosion;
        public float size;
        public boolean causesFire;

        public Data(Level level, Explosion explosion) {
            this.level = level;
            this.explosion = explosion;
            this.size = explosion.f_46017_;
            this.causesFire = explosion.f_46009_;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public Vec3 getPosition() {
            return this.explosion.getPosition();
        }
    }
}

