/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.config;

import net.minecraftforge.common.ForgeConfigSpec;

public interface IConfigurable {
    public String getName();

    public String getComment();

    default public boolean requiresWorldRestart() {
        return false;
    }

    default public boolean isBuilt() {
        return false;
    }

    default public void build(ForgeConfigSpec.Builder builder) {
        String comment = this.buildComment();
        if (!comment.equals("")) {
            builder.comment(comment);
        }
        if (this.requiresWorldRestart()) {
            builder.worldRestart();
        }
    }

    default public void onReload() {
    }

    private String buildComment() {
        String comment = this.getComment();
        if (!comment.isEmpty() && this.requiresWorldRestart()) {
            if (comment.endsWith(".")) {
                return comment.substring(0, comment.length() - 1) + " (requires world/game restart).";
            }
            return comment + " (requires world/game restart)";
        }
        return comment;
    }
}

