/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.commands;

import com.mlib.Utility;
import com.mlib.commands.CommandData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.command.EnumArgument;

public class CommandBuilder {
    final List<List<IModification>> modifications = new ArrayList<List<IModification>>();
    final List<ArgumentBuilder<CommandSourceStack, ?>> arguments;

    public CommandBuilder(CommandBuilder builder) {
        builder.modifications.forEach(modification -> this.modifications.add(new ArrayList(modification)));
        this.arguments = new ArrayList(builder.arguments);
    }

    public CommandBuilder() {
        this.arguments = new ArrayList();
    }

    public CommandBuilder copy() {
        return new CommandBuilder(this);
    }

    public CommandBuilder add(Predicate<CommandSourceStack> predicate) {
        return this.add((CommandBuilder builder) -> builder.getLastArgument().requires(predicate));
    }

    public CommandBuilder addArgument(Supplier<ArgumentBuilder<CommandSourceStack, ?>> argument) {
        return this.add((CommandBuilder builder) -> builder.addArgument((ArgumentBuilder)argument.get()));
    }

    public CommandBuilder literal(String ... names) {
        ArrayList<IModification> modifications = new ArrayList<IModification>();
        for (String name : names) {
            modifications.add(builder -> builder.addArgument((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_((String)name)));
        }
        return this.add(modifications);
    }

    public CommandBuilder integer() {
        return this.integer("value");
    }

    public CommandBuilder integer(String name) {
        return this.addArgument(() -> Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer()));
    }

    public CommandBuilder integer(int min) {
        return this.integer("value", min);
    }

    public CommandBuilder integer(String name, int min) {
        return this.addArgument(() -> Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer((int)min)));
    }

    public CommandBuilder integer(int min, int max) {
        return this.integer("value", min, max);
    }

    public CommandBuilder integer(String name, int min, int max) {
        return this.addArgument(() -> Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer((int)min, (int)max)));
    }

    public <EnumType extends Enum<EnumType>> CommandBuilder enumeration(Class<EnumType> enumClass) {
        return this.enumeration(enumClass.getSimpleName().toLowerCase(), enumClass);
    }

    public <EnumType extends Enum<EnumType>> CommandBuilder enumeration(String name, Class<EnumType> enumClass) {
        return this.addArgument(() -> Commands.m_82129_((String)name, (ArgumentType)EnumArgument.enumArgument((Class)enumClass)));
    }

    public CommandBuilder position() {
        return this.position("position");
    }

    public CommandBuilder position(String name) {
        return this.addArgument(() -> Commands.m_82129_((String)name, (ArgumentType)Vec3Argument.m_120841_()));
    }

    public CommandBuilder entity() {
        return this.entity("entity");
    }

    public CommandBuilder entity(String name) {
        return this.addArgument(() -> Commands.m_82129_((String)name, (ArgumentType)EntityArgument.m_91449_()));
    }

    public CommandBuilder entities() {
        return this.entities("entities");
    }

    public CommandBuilder entities(String name) {
        return this.addArgument(() -> Commands.m_82129_((String)name, (ArgumentType)EntityArgument.m_91460_()));
    }

    public CommandBuilder anyPosition() {
        ArrayList<IModification> modifications = new ArrayList<IModification>();
        modifications.add(builder -> builder.addArgument((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_())));
        modifications.add(builder -> builder.addArgument((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_())));
        modifications.add(builder -> builder.addArgument((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_())));
        return this.add(modifications);
    }

    public CommandBuilder hasPermission(int requiredLevel) {
        return this.add((CommandSourceStack stack) -> stack.m_6761_(requiredLevel));
    }

    public CommandBuilder isPlayer() {
        return this.add((CommandSourceStack stack) -> stack.m_81373_() instanceof Player);
    }

    public CommandBuilder isDevelopmentBuild() {
        return this.add((CommandSourceStack stack) -> Utility.isDevBuild());
    }

    public CommandBuilder execute(IExecutable executable) {
        return this.add((CommandBuilder builder) -> builder.getLastArgument().executes(context -> executable.execute(new CommandData((CommandContext<CommandSourceStack>)context))));
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        List<List<Integer>> permutations = this.generatePermutations();
        for (List<Integer> permutation : permutations) {
            this.clearArguments();
            for (int idx = 0; idx < permutation.size(); ++idx) {
                this.modifications.get(idx).get(permutation.get(idx)).apply(this);
            }
            this.mergeArguments();
            try {
                dispatcher.register((LiteralArgumentBuilder)this.getFirstArgument());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("First argument of any command must be a literal");
            }
        }
    }

    private void addArgument(ArgumentBuilder<CommandSourceStack, ?> argument) {
        this.arguments.add(argument);
    }

    private void clearArguments() {
        this.arguments.clear();
    }

    private boolean emptyArguments() {
        return this.arguments.size() <= 0;
    }

    private ArgumentBuilder<CommandSourceStack, ?> getFirstArgument() {
        if (this.emptyArguments()) {
            throw new IllegalArgumentException();
        }
        return this.arguments.get(0);
    }

    private ArgumentBuilder<CommandSourceStack, ?> getLastArgument() {
        if (this.emptyArguments()) {
            throw new IllegalArgumentException();
        }
        return this.arguments.get(this.arguments.size() - 1);
    }

    private void mergeArguments() {
        if (this.arguments.size() < 2) {
            return;
        }
        for (int idx = this.arguments.size(); idx >= 2; --idx) {
            ArgumentBuilder<CommandSourceStack, ?> previousArgument = this.arguments.get(idx - 2);
            ArgumentBuilder<CommandSourceStack, ?> nextArgument = this.arguments.get(idx - 1);
            previousArgument.then(nextArgument);
        }
    }

    private List<List<Integer>> generatePermutations() {
        ArrayList<List<Integer>> permutations = new ArrayList<List<Integer>>();
        permutations.add(new ArrayList());
        for (List<IModification> modification : this.modifications) {
            ArrayList newPermutations = new ArrayList();
            for (int idx = 0; idx < modification.size(); ++idx) {
                ArrayList copy = new ArrayList();
                for (List list : permutations) {
                    copy.add(new ArrayList(list));
                }
                for (List list : copy) {
                    list.add(idx);
                }
                newPermutations.addAll(copy);
            }
            permutations = newPermutations;
        }
        return permutations;
    }

    private CommandBuilder add(IModification modification) {
        ArrayList<IModification> modifications = new ArrayList<IModification>();
        modifications.add(modification);
        return this.add(modifications);
    }

    private CommandBuilder add(List<IModification> modifications) {
        this.modifications.add(modifications);
        return this;
    }

    @FunctionalInterface
    public static interface IModification {
        public void apply(CommandBuilder var1);
    }

    public static class DefaultKeys {
        public static final String ENTITIES = "entities";
        public static final String ENTITY = "entity";
        public static final String INT = "value";
        public static final String POSITION = "position";
    }

    @FunctionalInterface
    public static interface IExecutable {
        public int execute(CommandData var1) throws CommandSyntaxException;
    }
}

