/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.animations;

public enum InterpolationType {
    LINEAR(x -> x),
    SQUARE(x -> x * x),
    SQUARE_ROOT(x -> (float)Math.sqrt(x)),
    CUBE(x -> x * x * x),
    CUBE_ROOT(x -> (float)Math.pow(x, 0.3333333333333333)),
    SMOOTH(x -> x * x * (3.0f - 2.0f * x));

    private final IFormula formula;

    private InterpolationType(IFormula formula) {
        this.formula = formula;
    }

    public float apply(float ratio) {
        return this.formula.apply(ratio);
    }

    static interface IFormula {
        public float apply(float var1);
    }
}

