/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.eatinganimation;

import com.google.common.collect.Lists;
import com.matyrobbrt.eatinganimation.EatingAnimation;
import com.matyrobbrt.eatinganimation.pack.ModCompatResourcePack;
import com.mojang.bridge.game.GameVersion;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.DataPackConfig;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.resource.DelegatingResourcePack;

public class ClientSetup {
    public static final ItemPropertyFunction EAT_PROPERTY = (stack, world, entity, i) -> {
        if (entity == null) {
            return 0.0f;
        }
        if (entity instanceof RemotePlayer && entity.m_21252_() > 31) {
            return EatingAnimation.animationTicks / 30.0f;
        }
        return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 30.0f;
    };
    private static final ItemPropertyFunction EATING_PROPERTY = (stack, world, entity, i) -> {
        if (entity == null) {
            return 0.0f;
        }
        return entity.m_6117_() && entity.m_21211_() == stack && stack.m_41720_().m_41472_() ? 1.0f : 0.0f;
    };
    public static final ItemPropertyFunction DRINK_PROPERTY = (itemStack, clientWorld, livingEntity, i) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 30.0f;
    };
    private static final ItemPropertyFunction DRINKING_PROPERTY = (itemStack, clientWorld, livingEntity, i) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        return livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack && itemStack.m_41720_().m_6164_(itemStack) == UseAnim.DRINK ? 1.0f : 0.0f;
    };

    public ClientSetup(IEventBus modBus) {
        modBus.addListener(this::onClientSetup);
        modBus.addListener(this::onPackFinders);
        modBus.addListener(this::onLoadComplete);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.registerGeneric((ResourceLocation)new ResourceLocation("eatinganimation", "eat"), (ItemPropertyFunction)EAT_PROPERTY);
        ItemProperties.registerGeneric((ResourceLocation)new ResourceLocation("eatinganimation", "eating"), (ItemPropertyFunction)EATING_PROPERTY);
        ItemProperties.registerGeneric((ResourceLocation)new ResourceLocation("eatinganimation", "drink"), (ItemPropertyFunction)DRINK_PROPERTY);
        ItemProperties.registerGeneric((ResourceLocation)new ResourceLocation("eatinganimation", "drinking"), (ItemPropertyFunction)DRINKING_PROPERTY);
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        if (!EatingAnimation.wasInstalledBefore) {
            ArrayList listBefore = Lists.newArrayList((Iterable)Minecraft.m_91087_().m_91099_().m_10523_());
            if (listBefore.contains("mod:eatinganimation")) {
                listBefore.remove("mod:eatinganimation");
            }
            listBefore.add("mod:eatinganimation");
            Minecraft.m_91087_().m_91099_().m_10509_((Collection)listBefore);
        }
    }

    private void onPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        Function<String, Path> fileGetter = name -> ModList.get().getModFileById("eatinganimation").getFile().findResource(new String[]{"compat", name});
        event.addRepositorySource((source, factory) -> {
            ArrayList<ModCompatResourcePack> packs = new ArrayList<ModCompatResourcePack>();
            for (String mod : EatingAnimation.compatibleMods) {
                if (!ModList.get().isLoaded(mod)) continue;
                String packName = "eatinganimations:compat/" + mod;
                packs.add(new ModCompatResourcePack((Path)fileGetter.apply(mod), mod));
                DataPackConfig.f_45842_.addModPacks(List.of(packName));
            }
            Pack fullPack = Pack.m_10430_((String)"eatinganimations_compat", (boolean)false, () -> new DelegatingResourcePack("eatinganimations_compat", "EatingAnimations Compat", new PackMetadataSection((Component)new TranslatableComponent("eatinganimations.resources.compat"), PackType.CLIENT_RESOURCES.m_143756_((GameVersion)SharedConstants.m_183709_())), packs), (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_);
            source.accept(fullPack);
        });
    }
}

