/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.network.PacketWandOption;

public class ScreenWand
extends Screen {
    private final ItemStack wand;
    private final WandOptions wandOptions;
    private static final int BUTTON_WIDTH = 160;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SPACING_WIDTH = 50;
    private static final int SPACING_HEIGHT = 30;
    private static final int N_COLS = 2;
    private static final int N_ROWS = 3;
    private static final int FIELD_WIDTH = 370;
    private static final int FIELD_HEIGHT = 120;

    public ScreenWand(ItemStack wand) {
        super((Component)new TextComponent("ScreenWand"));
        this.wand = wand;
        this.wandOptions = new WandOptions(wand);
    }

    protected void m_7856_() {
        this.createButton(0, 0, this.wandOptions.cores);
        this.createButton(0, 1, this.wandOptions.lock);
        this.createButton(0, 2, this.wandOptions.direction);
        this.createButton(1, 0, this.wandOptions.replace);
        this.createButton(1, 1, this.wandOptions.match);
        this.createButton(1, 2, this.wandOptions.random);
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        ScreenWand.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.wand.m_41611_(), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 60 - 30), (int)0xFFFFFF);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void createButton(int cx, int cy, IOption<?> option) {
        Button button = new Button(this.getX(cx), this.getY(cy), 160, 20, this.getButtonLabel(option), bt -> this.clickButton(bt, option), (bt, ms, x, y) -> this.drawTooltip(ms, x, y, option));
        button.f_93623_ = option.isEnabled();
        this.m_142416_((GuiEventListener)button);
    }

    private void clickButton(Button button, IOption<?> option) {
        option.next();
        ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketWandOption(option, false));
        button.m_93666_(this.getButtonLabel(option));
    }

    private void drawTooltip(PoseStack matrixStack, int mouseX, int mouseY, IOption<?> option) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent(option.getDescTranslation()), mouseX, mouseY);
        }
    }

    private int getX(int n) {
        return this.f_96543_ / 2 - 185 + n * 210;
    }

    private int getY(int n) {
        return this.f_96544_ / 2 - 60 + n * 50;
    }

    private Component getButtonLabel(IOption<?> option) {
        return new TranslatableComponent(option.getKeyTranslation()).m_7220_((Component)new TranslatableComponent(option.getValueTranslation()));
    }
}

