/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.recipes.collect;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.ingredients.IIngredientSupplier;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.recipes.collect.RecipeIngredientTable;
import mezz.jei.core.collect.SetMultiMap;
import org.jetbrains.annotations.UnmodifiableView;

public class RecipeMap {
    private final RecipeIngredientTable recipeTable = new RecipeIngredientTable();
    private final SetMultiMap<String, RecipeType<?>> ingredientUidToCategoryMap = new SetMultiMap();
    private final SetMultiMap<String, RecipeType<?>> categoryCatalystUidToRecipeCategoryMap = new SetMultiMap();
    private final Comparator<RecipeType<?>> recipeTypeComparator;
    private final RegisteredIngredients registeredIngredients;
    private final RecipeIngredientRole role;

    public RecipeMap(Comparator<RecipeType<?>> recipeTypeComparator, RegisteredIngredients registeredIngredients, RecipeIngredientRole role) {
        this.recipeTypeComparator = recipeTypeComparator;
        this.registeredIngredients = registeredIngredients;
        this.role = role;
    }

    public Stream<RecipeType<?>> getRecipeTypes(String ingredientUid) {
        Collection recipeCategoryUids = this.ingredientUidToCategoryMap.get((Object)ingredientUid);
        Collection catalystRecipeCategoryUids = this.categoryCatalystUidToRecipeCategoryMap.get((Object)ingredientUid);
        return Stream.concat(recipeCategoryUids.stream(), catalystRecipeCategoryUids.stream()).sorted(this.recipeTypeComparator);
    }

    public void addCatalystForCategory(RecipeType<?> recipeType, String ingredientUid) {
        this.categoryCatalystUidToRecipeCategoryMap.put(ingredientUid, recipeType);
    }

    public <T> @UnmodifiableView List<T> getRecipes(RecipeType<T> recipeType, String ingredientUid) {
        return this.recipeTable.get(recipeType, ingredientUid);
    }

    public <T> boolean isCatalystForRecipeCategory(RecipeType<T> recipeType, String ingredientUid) {
        Collection catalystCategories = this.categoryCatalystUidToRecipeCategoryMap.get((Object)ingredientUid);
        return catalystCategories.contains(recipeType);
    }

    public <T> void addRecipe(RecipeType<T> recipeType, T recipe, IIngredientSupplier ingredientSupplier) {
        ingredientSupplier.getIngredientTypes(this.role).forEach(ingredientType -> this.addRecipe(recipe, recipeType, ingredientSupplier, (IIngredientType)ingredientType));
    }

    private <T, V> void addRecipe(T recipe, RecipeType<T> recipeType, IIngredientSupplier ingredientSupplier, IIngredientType<V> ingredientType) {
        IIngredientHelper ingredientHelper = this.registeredIngredients.getIngredientHelper(ingredientType);
        List<String> ingredientUids = ingredientSupplier.getIngredientStream(ingredientType, this.role).filter(ingredientHelper::isValidIngredient).map(i -> ingredientHelper.getUniqueId(i, UidContext.Recipe)).distinct().toList();
        if (!ingredientUids.isEmpty()) {
            for (String uid : ingredientUids) {
                this.ingredientUidToCategoryMap.put(uid, recipeType);
            }
            this.recipeTable.add(recipe, recipeType, ingredientUids);
        }
    }
}

