/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import tschipp.fakename.CommandFakeName;
import tschipp.fakename.FakeName;
import tschipp.fakename.FakeNamePacket;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FakenameEvents {
    @SubscribeEvent
    public static void serverLoad(RegisterCommandsEvent event) {
        CommandFakeName.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void renderName(PlayerEvent.NameFormat event) {
        CompoundTag tag = event.getPlayer().getPersistentData();
        if (tag.m_128441_("fakename")) {
            event.setDisplayname((Component)new TextComponent(tag.m_128461_("fakename")));
        } else {
            event.setDisplayname(event.getUsername());
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.f_46443_) {
            if (player.getPersistentData().m_128441_("fakename")) {
                FakeName.sendPacket(player, player.getPersistentData().m_128461_("fakename"), 0);
            }
            for (Player other : player.m_20194_().m_6846_().m_11314_()) {
                if (!other.getPersistentData().m_128441_("fakename")) continue;
                FakeName.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new FakeNamePacket(other.getPersistentData().m_128461_("fakename"), other.m_142049_(), 0));
            }
        }
    }

    @SubscribeEvent
    public static void onTracking(PlayerEvent.StartTracking event) {
        Player targetPlayer;
        if (event.getTarget() instanceof Player && (targetPlayer = (Player)event.getTarget()).getPersistentData() != null && targetPlayer.getPersistentData().m_128441_("fakename")) {
            ServerPlayer toRecieve = (ServerPlayer)event.getPlayer();
            FakeName.network.send(PacketDistributor.PLAYER.with(() -> toRecieve), (Object)new FakeNamePacket(targetPlayer.getPersistentData().m_128461_("fakename"), targetPlayer.m_142049_(), 0));
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getPlayer();
        if (oldPlayer.getPersistentData().m_128441_("fakename")) {
            String fakename = oldPlayer.getPersistentData().m_128461_("fakename");
            newPlayer.getPersistentData().m_128359_("fakename", fakename);
        }
    }
}

