/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import tschipp.fakename.CommandFakeName;
import tschipp.fakename.Config;
import tschipp.fakename.FakeNamePacket;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="fakename")
public class FakeName {
    public static final String MODID = "fakename";
    public static SimpleChannel network;
    public static IModInfo info;

    public FakeName() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        info = ModLoadingContext.get().getActiveContainer().getModInfo();
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "fakenamechannel"), () -> info.getVersion().toString(), s -> true, s -> true);
            network.registerMessage(0, FakeNamePacket.class, FakeNamePacket::toBytes, FakeNamePacket::new, FakeNamePacket::handle);
            ArgumentTypes.m_121601_((String)"fakename:fakename", CommandFakeName.FakenameArgumentType.class, (ArgumentSerializer)new CommandFakeName.FakenameArgumentType.Serializer());
        });
    }

    public static void sendPacket(Player player, String fakename, int operation) {
        FakeName.performFakenameOperation(player, fakename, operation);
        network.send(PacketDistributor.ALL.noArg(), (Object)new FakeNamePacket(fakename, player.m_142049_(), operation));
    }

    public static void performFakenameOperation(Player player, String fakename, int operation) {
        CompoundTag tag = player.getPersistentData();
        if (operation == 0) {
            tag.m_128359_(MODID, fakename);
            player.refreshDisplayName();
        } else {
            tag.m_128473_(MODID);
            player.refreshDisplayName();
        }
    }
}

