/*
 * Decompiled with CFR 0.152.
 */
package mrunknown404.dice.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mrunknown404.dice.entity.D6Model;
import mrunknown404.dice.entity.DiceEntity;
import mrunknown404.dice.entity.DiceModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DiceEntityRenderer
extends EntityRenderer<DiceEntity>
implements EntityRendererProvider<DiceEntity> {
    private static final ResourceLocation D6_TEX = new ResourceLocation("dice", "textures/entity/d6.png");
    private static final D6Model D6_MODEL = new D6Model();
    private ResourceLocation tex;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public DiceEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(DiceEntity dice, float var1, float var2, PoseStack stack, MultiBufferSource buf, int var3) {
        D6Model model = null;
        switch (dice.getDiceType()) {
            case 4: {
                break;
            }
            case 6: {
                model = D6_MODEL;
                this.tex = D6_TEX;
                break;
            }
            case 8: {
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                break;
            }
        }
        if (model == null) {
            System.err.println("Invalid dice? " + dice.getDiceType());
            return;
        }
        boolean flag = !dice.m_20145_();
        RenderType rendertype = this.getRenderType(dice, model, flag, !flag && !dice.m_20177_((Player)this.minecraft.f_91074_), this.minecraft.m_91314_((Entity)dice));
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = buf.m_6299_(rendertype);
            ((DiceModel)model).setupRotation(dice);
            model.m_7695_(stack, ivertexbuilder, var3, DiceEntityRenderer.getOverlayCoords(0.0f), (float)dice.getRed() / 255.0f, (float)dice.getGreen() / 255.0f, (float)dice.getBlue() / 255.0f, 1.0f);
        }
    }

    private static int getOverlayCoords(float f) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)f), (int)OverlayTexture.m_118096_((boolean)false));
    }

    private RenderType getRenderType(DiceEntity dice, DiceModel model, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = this.getTextureLocation(dice);
        if (p_230496_3_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return model.m_103119_(resourcelocation);
        }
        return p_230496_4_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    public ResourceLocation getTextureLocation(DiceEntity dice) {
        return this.tex;
    }

    public EntityRenderer<DiceEntity> m_174009_(EntityRendererProvider.Context ctx) {
        return new DiceEntityRenderer(ctx);
    }
}

