/*
 * Decompiled with CFR 0.152.
 */
package mrunknown404.dice.entity;

import java.awt.Color;
import java.util.Random;
import mrunknown404.dice.registries.DiceRegistry;
import mrunknown404.dice.utils.DiceConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class DiceEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_ROLLED = SynchedEntityData.m_135353_(DiceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_DICE_TYPE = SynchedEntityData.m_135353_(DiceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_RED = SynchedEntityData.m_135353_(DiceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_GREEN = SynchedEntityData.m_135353_(DiceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_BLUE = SynchedEntityData.m_135353_(DiceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int life;
    private boolean lastTickOnGround;

    public DiceEntity(EntityType<? extends DiceEntity> type, Level world) {
        super(type, world);
        this.setRed(0);
        this.setGreen(0);
        this.setBlue(0);
        this.setDiceType(0);
    }

    public DiceEntity(Level world, Entity entity, Color color, int diceType) {
        super((EntityType)DiceRegistry.DICE_ENTITY.get(), world);
        this.m_6034_(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_());
        this.setRed(color.getRed());
        this.setGreen(color.getGreen());
        this.setBlue(color.getBlue());
        this.setDiceType(diceType);
    }

    public void m_8119_() {
        double d0;
        int i;
        super.m_8119_();
        ++this.life;
        if (this.life >= 20 * (Integer)DiceConfig.COMMON.diceExpireTime.get()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.15625, 0.0);
        }
        if (!this.m_6084_()) {
            return;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        Vec3 vector3d = this.m_20184_();
        float f = this.m_20192_() - 0.11111111f;
        if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > (double)f) {
            this.setUnderwaterMovement();
        } else if (this.m_20077_() && this.m_204036_(FluidTags.f_13132_) > (double)f) {
            this.setUnderLavaMovement();
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if (this.f_19853_.f_46443_) {
            this.f_19794_ = false;
        } else {
            boolean bl = this.f_19794_ = !this.f_19853_.m_45786_((Entity)this);
            if (this.f_19794_) {
                this.m_20314_(this.m_20185_(), (this.m_142469_().f_82289_ + this.m_142469_().f_82292_) / 2.0, this.m_20189_());
            }
        }
        BlockState state = this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()));
        if (!this.f_19861_ || this.getHorizontalDistanceSqr(this.m_20184_()) > (double)1.0E-5f || (this.f_19797_ + this.m_142049_()) % 4 == 0) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            float f1 = 0.98f;
            if (this.f_19861_) {
                f1 = state.getFriction((LevelReader)this.f_19853_, new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), (Entity)this) * 0.98f;
            }
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
            if (this.f_19861_) {
                Vec3 vector3d1 = this.m_20184_();
                if (vector3d1.f_82480_ < 0.0) {
                    this.m_20256_(vector3d1.m_82542_(1.0, -0.5, 1.0));
                }
            }
        }
        boolean flag = Math.floor(this.f_19854_) != Math.floor(this.m_20185_()) || Math.floor(this.f_19855_) != Math.floor(this.m_20186_()) || Math.floor(this.f_19856_) != Math.floor(this.m_20189_());
        int n = i = flag ? 2 : 40;
        if (this.f_19797_ % i == 0 && this.f_19853_.m_6425_(this.m_142538_()).m_205070_(FluidTags.f_13132_) && !this.m_5825_()) {
            this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.nextFloat() * 0.4f);
        }
        this.f_19812_ |= this.m_20073_();
        if (!this.f_19853_.f_46443_ && (d0 = this.m_20184_().m_82546_(vector3d).m_82556_()) > 0.01) {
            this.f_19812_ = true;
        }
        if (this.f_19861_ && !this.lastTickOnGround) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), state.m_60827_().m_56776_(), SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19796_.nextFloat() * 0.4f + 0.8f));
        }
        this.lastTickOnGround = this.f_19861_;
    }

    private void setUnderwaterMovement() {
        Vec3 vector3d = this.m_20184_();
        this.m_20334_(vector3d.f_82479_ * (double)0.99f, vector3d.f_82480_ + (double)(vector3d.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.f_82481_ * (double)0.99f);
    }

    private void setUnderLavaMovement() {
        Vec3 vector3d = this.m_20184_();
        this.m_20334_(vector3d.f_82479_ * (double)0.95f, vector3d.f_82480_ + (double)(vector3d.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vector3d.f_82481_ * (double)0.95f);
    }

    public void shootFromRotation(Entity entity, float p_234612_2_, float p_234612_3_, float p_234612_4_, float p_234612_5_, float p_234612_6_) {
        double f = -Math.sin((double)p_234612_3_ * (Math.PI / 180)) * Math.cos((double)p_234612_2_ * (Math.PI / 180));
        double f1 = -Math.sin((p_234612_2_ + p_234612_4_) * ((float)Math.PI / 180));
        double f2 = Math.cos((double)p_234612_3_ * (Math.PI / 180)) * Math.cos((double)p_234612_2_ * (Math.PI / 180));
        this.shoot(f, f1, f2, p_234612_5_, p_234612_6_);
        Vec3 vector3d = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vector3d.f_82479_, entity.m_20096_() ? 0.0 : vector3d.f_82480_, vector3d.f_82481_));
    }

    private void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vec3 vector3d = new Vec3(p_70186_1_, p_70186_3_, p_70186_5_).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_).m_82490_((double)p_70186_7_);
        this.m_20256_(vector3d);
        double f = Math.sqrt(this.getHorizontalDistanceSqr(vector3d));
        this.f_19859_ = (float)(Math.atan2(vector3d.f_82479_, vector3d.f_82481_) * 57.2957763671875);
        this.f_19860_ = (float)(Math.atan2(vector3d.f_82480_, f) * 57.2957763671875);
    }

    private double getHorizontalDistanceSqr(Vec3 vec) {
        double d0 = this.m_20185_() - vec.f_82479_;
        double d2 = this.m_20189_() - vec.f_82481_;
        return d0 * d0 + d2 * d2;
    }

    public boolean m_6783_(double dist) {
        return dist > 1.0;
    }

    private void setRoll(int roll) {
        this.m_20088_().m_135381_(DATA_ROLLED, (Object)roll);
    }

    public void setRoll(Random r) {
        this.m_20088_().m_135381_(DATA_ROLLED, (Object)(1 + r.nextInt(this.getDiceType())));
    }

    protected int getRoll() {
        return (Integer)this.m_20088_().m_135370_(DATA_ROLLED);
    }

    public void setRed(int red) {
        this.m_20088_().m_135381_(DATA_RED, (Object)red);
    }

    protected int getRed() {
        return (Integer)this.m_20088_().m_135370_(DATA_RED);
    }

    public void setGreen(int green) {
        this.m_20088_().m_135381_(DATA_GREEN, (Object)green);
    }

    protected int getGreen() {
        return (Integer)this.m_20088_().m_135370_(DATA_GREEN);
    }

    public void setBlue(int blue) {
        this.m_20088_().m_135381_(DATA_BLUE, (Object)blue);
    }

    protected int getBlue() {
        return (Integer)this.m_20088_().m_135370_(DATA_BLUE);
    }

    public void setDiceType(int diceType) {
        this.m_20088_().m_135381_(DATA_DICE_TYPE, (Object)diceType);
    }

    protected int getDiceType() {
        return (Integer)this.m_20088_().m_135370_(DATA_DICE_TYPE);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ROLLED, (Object)0);
        this.m_20088_().m_135372_(DATA_RED, (Object)0);
        this.m_20088_().m_135372_(DATA_GREEN, (Object)0);
        this.m_20088_().m_135372_(DATA_BLUE, (Object)0);
        this.m_20088_().m_135372_(DATA_DICE_TYPE, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Roll", this.getRoll());
        nbt.m_128405_("Life", this.life);
        nbt.m_128405_("Red", this.getRed());
        nbt.m_128405_("Green", this.getGreen());
        nbt.m_128405_("Blue", this.getBlue());
        nbt.m_128405_("DiceType", this.getDiceType());
    }

    public void m_7378_(CompoundTag nbt) {
        this.setRoll(nbt.m_128451_("Roll"));
        this.life = nbt.m_128451_("Life");
        this.setRed(nbt.m_128451_("Red"));
        this.setGreen(nbt.m_128451_("Green"));
        this.setBlue(nbt.m_128451_("Blue"));
        this.setDiceType(nbt.m_128451_("DiceType"));
    }
}

