/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.panels;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.panels.JSHelper;
import org.zeith.solarflux.panels.SolarPanel;

public class SolarScriptEngine {
    final ScriptEngine engine;
    final Invocable engineInvocable;
    private static final NashornScriptEngineFactory NASHORN_FACTORY = new NashornScriptEngineFactory();

    public SolarScriptEngine(Stream<String> lines) throws ScriptException {
        StringBuilder content = new StringBuilder();
        HashMap defines = new HashMap();
        lines.forEach(ln -> {
            AtomicReference<String> tmp = new AtomicReference<String>((String)ln);
            defines.forEach((src, dst) -> tmp.set(((String)tmp.get()).replaceAll((String)src, (String)dst)));
            ln = tmp.get();
            if (((String)ln).startsWith("define ")) {
                String[] kv = ((String)ln).substring(7).split(" ", 2);
                if (kv.length == 2) {
                    defines.put(kv[0], kv[1]);
                }
                ln = "// Processed: " + (String)ln;
            }
            if (((String)ln).startsWith("import ") && ((String)ln).endsWith(";")) {
                String clazz = ((String)ln).substring(7, ((String)ln).length() - 1);
                ln = "var " + clazz.substring(clazz.lastIndexOf(46) + 1) + " = Java.type(\"" + clazz + "\");";
            }
            content.append((String)ln).append(System.lineSeparator());
        });
        this.engine = SolarScriptEngine.newEngine();
        this.engineInvocable = (Invocable)((Object)this.engine);
        this.engine.eval(content.toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void reloadRecipes(RegisterRecipesEvent e) {
        try {
            this.callFunction("registerRecipes", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable er) {
            er.printStackTrace();
        }
    }

    public Object callFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.engineInvocable.invokeFunction(name, args);
    }

    public static ScriptEngine newEngine() {
        ScriptEngine se = NASHORN_FACTORY.getScriptEngine();
        try {
            se.put("panel", se.eval("function(){return Java.type('" + SolarPanel.class.getName() + "').customBuilder();}"));
            se.put("ingredient", se.eval("function(e){return Java.type('" + RecipeHelper.class.getName() + "').fromComponent(e);}"));
            se.put("isEmpty", se.eval("function(e){return Java.type('" + SolarScriptEngine.class.getName() + "').isEmpty(e);}"));
            se.put("newMaterial", se.eval("function(name){return Java.type('" + SolarFlux.class.getName() + "').newJSItem(name);}"));
            se.put("item", se.eval("function(mod, id){var js=Java.type('" + JSHelper.class.getName() + "');if(!id){return js.item(mod);}else{return js.item(mod,id);}}"));
            se.put("tag", se.eval("function(mod, id){var js=Java.type('" + JSHelper.class.getName() + "');if(!id){return js.tag(mod);}else{return js.tag(mod,id);}}"));
            se.put("isModLoaded", se.eval("function(mod){return Java.type('" + ModList.class.getName() + "').get().isLoaded(mod);}"));
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return se;
    }

    public static boolean isEmpty(Object o) {
        FluidStack f;
        ItemStack s;
        Ingredient i;
        if (o instanceof Ingredient && (i = (Ingredient)o).m_43947_()) {
            return true;
        }
        if (o instanceof ItemStack && (s = (ItemStack)o).m_41619_()) {
            return true;
        }
        if (o instanceof FluidStack && (f = (FluidStack)o).isEmpty()) {
            return true;
        }
        return o == null;
    }
}

