/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.zeith.solarflux.SolarFlux;

public class JSItem
extends Item {
    LanguageData langs;

    public JSItem(Item.Properties properties, LanguageData langs) {
        super(properties);
        this.langs = langs;
    }

    public boolean hasLang() {
        return this.langs != null;
    }

    public LanguageData getLang() {
        return this.langs;
    }

    public static class LanguageData {
        public final Map<String, String> langToName = new HashMap<String, String>();
        public String def;
        final FutureJSGenerator material;

        public LanguageData(FutureJSGenerator material) {
            this.material = material;
        }

        public LanguageData put(String lang, String loc) {
            if ((lang = lang.toLowerCase()).equalsIgnoreCase("en_us")) {
                this.def = loc;
            }
            this.langToName.put(lang, loc);
            return this;
        }

        public String getName(String lang) {
            return this.langToName.getOrDefault(lang, this.def);
        }

        public ItemLike build() {
            if (this.def == null) {
                throw new RuntimeException("Unable to apply languages: no 'en_us' value found!");
            }
            this.material.langs = this;
            return this.material;
        }
    }

    public static class FutureJSGenerator
    implements ItemLike {
        public final String name;
        private JSItem item;
        private LanguageData langs;

        public FutureJSGenerator(String name) {
            this.name = name;
        }

        public LanguageData langBuilder() {
            return new LanguageData(this);
        }

        public JSItem create() {
            if (this.item != null) {
                return this.item;
            }
            JSItem i = new JSItem(new Item.Properties().m_41491_(SolarFlux.ITEM_GROUP), this.langs);
            i.setRegistryName(this.name);
            this.item = i;
            return i;
        }

        public Item m_5456_() {
            return this.item;
        }
    }
}

