/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.block.SolarPanelTile;

public class SolarPanelBakedModel
implements IDynamicBakedModel {
    public static final FaceBakery COOKER = new FaceBakery();
    public final SolarPanelBlock block;
    final ResourceLocation modelName = new ModelResourceLocation("solarflux", "solar_panel");
    public static final ModelState ZERO_SPRITE = new ModelState(){};
    final Function<ResourceLocation, TextureAtlasSprite> spriteGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
    ResourceLocation baseTx;
    ResourceLocation topTx;

    public SolarPanelBakedModel(SolarPanelBlock spb) {
        this.block = spb;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction sideIn, Random rand, IModelData extraData) {
        Direction[] sides;
        Direction[] directionArray;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (sideIn == null) {
            directionArray = Direction.values();
        } else {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = sideIn;
        }
        for (Direction side : sides = directionArray) {
            if (side == null) continue;
            Level world = (Level)extraData.getData(SolarPanelTile.WORLD_PROP);
            BlockPos pos = (BlockPos)extraData.getData(SolarPanelTile.POS_PROP);
            TextureAtlasSprite top = this.t_top();
            TextureAtlasSprite base = this.t_base();
            float h = this.block.panel.getPanelData().height * 16.0f;
            quads.add(COOKER.m_111600_(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, h, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, side.m_122434_() == Direction.Axis.Y ? 0.0f : 16.0f - h, 16.0f, 16.0f}, 4)), side == Direction.UP ? top : base, side, ZERO_SPRITE, null, true, this.modelName));
            if (world == null || pos == null) {
                return quads;
            }
            boolean west = false;
            boolean east = false;
            boolean north = false;
            boolean south = false;
            west = world.m_8055_(pos.m_142125_()).m_60734_() != this.block;
            if (west) {
                float[] fArray;
                Vector3f vector3f = new Vector3f(0.0f, h, 1.0f);
                Vector3f vector3f2 = new Vector3f(1.0f, h + 0.25f, 15.0f);
                if (side != Direction.UP) {
                    float[] fArray2 = new float[4];
                    fArray2[0] = 0.0f;
                    fArray2[1] = 0.0f;
                    fArray2[2] = 16.0f;
                    fArray = fArray2;
                    fArray2[3] = 1.0f;
                } else {
                    float[] fArray3 = new float[4];
                    fArray3[0] = 0.0f;
                    fArray3[1] = 0.0f;
                    fArray3[2] = 1.0f;
                    fArray = fArray3;
                    fArray3[3] = 16.0f;
                }
                quads.add(COOKER.m_111600_(vector3f, vector3f2, new BlockElementFace(null, 0, "#0", new BlockFaceUV(fArray, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (east = world.m_8055_(pos.m_142126_()).m_60734_() != this.block) {
                float[] fArray;
                Vector3f vector3f = new Vector3f(15.0f, h, 1.0f);
                Vector3f vector3f3 = new Vector3f(16.0f, h + 0.25f, 15.0f);
                if (side != Direction.UP) {
                    float[] fArray4 = new float[4];
                    fArray4[0] = 0.0f;
                    fArray4[1] = 0.0f;
                    fArray4[2] = 16.0f;
                    fArray = fArray4;
                    fArray4[3] = 1.0f;
                } else {
                    float[] fArray5 = new float[4];
                    fArray5[0] = 15.0f;
                    fArray5[1] = 0.0f;
                    fArray5[2] = 16.0f;
                    fArray = fArray5;
                    fArray5[3] = 16.0f;
                }
                quads.add(COOKER.m_111600_(vector3f, vector3f3, new BlockElementFace(null, 0, "#0", new BlockFaceUV(fArray, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (north = world.m_8055_(pos.m_142127_()).m_60734_() != this.block) {
                quads.add(COOKER.m_111600_(new Vector3f(1.0f, h, 0.0f), new Vector3f(15.0f, h + 0.25f, 1.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (south = world.m_8055_(pos.m_142128_()).m_60734_() != this.block) {
                quads.add(COOKER.m_111600_(new Vector3f(1.0f, h, 15.0f), new Vector3f(15.0f, h + 0.25f, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (west || north || world.m_8055_(pos.m_142125_().m_142127_()).m_60734_() != this.block) {
                quads.add(COOKER.m_111600_(new Vector3f(0.0f, h, 0.0f), new Vector3f(1.0f, h + 0.25f, 1.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 1.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (east || north || world.m_8055_(pos.m_142126_().m_142127_()).m_60734_() != this.block) {
                quads.add(COOKER.m_111600_(new Vector3f(15.0f, h, 0.0f), new Vector3f(16.0f, h + 0.25f, 1.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (south || east || world.m_8055_(pos.m_142128_().m_142126_()).m_60734_() != this.block) {
                quads.add(COOKER.m_111600_(new Vector3f(15.0f, h, 15.0f), new Vector3f(16.0f, h + 0.25f, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 15.0f, 16.0f, 16.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (!west && !south && world.m_8055_(pos.m_142125_().m_142128_()).m_60734_() == this.block) continue;
            quads.add(COOKER.m_111600_(new Vector3f(0.0f, h, 15.0f), new Vector3f(1.0f, h + 0.25f, 16.0f), new BlockElementFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 15.0f, 1.0f, 16.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
        }
        return quads;
    }

    public ItemTransforms m_7442_() {
        return new ItemTransforms(this.getTransform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND), this.getTransform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND), this.getTransform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND), this.getTransform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND), this.getTransform(ItemTransforms.TransformType.HEAD), this.getTransform(ItemTransforms.TransformType.GUI), this.getTransform(ItemTransforms.TransformType.GROUND), this.getTransform(ItemTransforms.TransformType.FIXED));
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransform getTransform(ItemTransforms.TransformType type) {
        switch (type) {
            case GUI: {
                return new ItemTransform(new Vector3f(30.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
            }
        }
        return ItemTransform.f_111754_;
    }

    public TextureAtlasSprite m_6160_() {
        return ThreadLocalRandom.current().nextInt(5) > 0 ? this.t_base() : this.t_top();
    }

    public TextureAtlasSprite t_base() {
        if (this.baseTx == null) {
            this.baseTx = new ResourceLocation(this.block.getRegistryName().m_135827_(), "blocks/" + this.block.getRegistryName().m_135815_() + "_base");
        }
        return this.spriteGetter.apply(this.baseTx);
    }

    public TextureAtlasSprite t_top() {
        if (this.topTx == null) {
            this.topTx = new ResourceLocation(this.block.getRegistryName().m_135827_(), "blocks/" + this.block.getRegistryName().m_135815_() + "_top");
        }
        return this.spriteGetter.apply(this.topTx);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }
}

