/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.dsc;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.morimori0317.dsc.CuttingDamageSource;
import net.morimori0317.dsc.DSCConfig;
import net.morimori0317.dsc.DangerousStoneCutterAPIImpl;
import net.morimori0317.dsc.api.DangerousStoneCutterAPI;
import net.morimori0317.dsc.explatform.DSCExpectPlatform;

public class DangerousStoneCutter {
    public static final String MODID = "dangerousstonecutter";

    public static void init() {
    }

    public static void huntStoneCutterDamage(Level level, BlockState blockState, BlockPos blockPos, Entity entity) {
        boolean flgISZ;
        VoxelShape shape = blockState.m_60812_((BlockGetter)level, blockPos);
        double enMaxX = entity.m_142469_().f_82291_;
        double enMaxZ = entity.m_142469_().f_82293_;
        double enMinX = entity.m_142469_().f_82288_;
        double enMinZ = entity.m_142469_().f_82290_;
        double shMaxX = shape.m_83297_(Direction.Axis.X) + (double)blockPos.m_123341_();
        double shMaxZ = shape.m_83297_(Direction.Axis.Z) + (double)blockPos.m_123343_();
        double shMinX = shape.m_83288_(Direction.Axis.X) + (double)blockPos.m_123341_();
        double shMinZ = shape.m_83288_(Direction.Axis.Z) + (double)blockPos.m_123343_();
        boolean flgIEX = enMaxX < shMaxX && enMaxX > shMinX || enMinX < shMaxX && enMinX > shMinX;
        boolean flgIEZ = enMaxZ < shMaxZ && enMaxZ > shMinZ || enMinZ < shMaxZ && enMinZ > shMinZ;
        boolean flgISX = shMaxX < enMaxX && shMaxX > enMinX || shMinX < enMaxX && shMinX > enMinX;
        boolean bl = flgISZ = shMaxZ < enMaxZ && shMaxZ > enMinZ || shMinZ < enMaxZ && shMinZ > enMinZ;
        if (!flgIEX && !flgISX || !flgIEZ && !flgISZ) {
            return;
        }
        if (entity.m_20182_().m_7098_() < shape.m_83297_(Direction.Axis.Y) + (double)blockPos.m_123342_()) {
            return;
        }
        entity.m_7601_(blockState, new Vec3((double)0.8f, 0.75, (double)0.8f));
        if (!level.m_5776_()) {
            boolean flg;
            if (entity instanceof ItemEntity) {
                return;
            }
            CuttingDamageSource dmg = new CuttingDamageSource(blockState);
            boolean bl2 = flg = entity.m_20145_() || entity.m_6673_((DamageSource)dmg);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                flg |= player.m_150110_().f_35934_;
            }
            entity.m_6469_((DamageSource)dmg, DangerousStoneCutter.getConfig().getDamage());
            if (flg) {
                return;
            }
            level.m_5594_(null, blockPos, SoundEvents.f_12494_, SoundSource.BLOCKS, 0.3f, 1.0f);
            if (DangerousStoneCutter.getConfig().isEnableBloodParticle()) {
                LevelChunk lch = (LevelChunk)level.m_46865_(entity.m_142538_());
                DSCExpectPlatform.sendBloodParticlePacket(lch, entity.m_142049_(), blockPos);
            }
        }
    }

    public static boolean isSupportStoneCutter(BlockState state) {
        if (DSCExpectPlatform.isSupportStoneCutter(state)) {
            return true;
        }
        return state.m_60734_() instanceof StonecutterBlock;
    }

    public static ParticleOptions getBloodParticle(Entity entity) {
        DangerousStoneCutterAPIImpl apiImpl = (DangerousStoneCutterAPIImpl)DangerousStoneCutterAPI.getInstance();
        for (Function<Entity, ParticleOptions> bloodParticleListener : apiImpl.getBloodParticleListeners()) {
            ParticleOptions r = bloodParticleListener.apply(entity);
            if (r == null) continue;
            return r;
        }
        if (entity instanceof WitherSkeleton || entity instanceof WitherBoss) {
            return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50080_.m_49966_());
        }
        if (entity instanceof Skeleton || entity instanceof SkeletonHorse) {
            return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50453_.m_49966_());
        }
        if (entity instanceof EnderMan || entity instanceof EnderDragon || entity instanceof Endermite || entity instanceof Shulker) {
            return ParticleTypes.f_123760_;
        }
        if (entity instanceof MagmaCube || entity instanceof Blaze) {
            return ParticleTypes.f_123744_;
        }
        if (entity instanceof Slime) {
            return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_());
        }
        if (entity instanceof IronGolem) {
            return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50075_.m_49966_());
        }
        if (entity instanceof Creeper) {
            return new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42403_));
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return new ItemParticleOption(ParticleTypes.f_123752_, itemEntity.m_32055_());
        }
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            return new BlockParticleOption(ParticleTypes.f_123794_, fallingBlock.m_31980_());
        }
        if ((entity instanceof Mob || entity instanceof Player) && !(entity instanceof Vex)) {
            return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_());
        }
        return null;
    }

    public static DSCConfig getConfig() {
        return DSCExpectPlatform.getConfig();
    }
}

