/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import vazkii.quark.addons.oddities.module.MagnetsModule;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;

public class MovingMagnetizedBlock
extends QuarkBlock
implements EntityBlock {
    public static final DirectionProperty FACING = PistonHeadBlock.f_52588_;

    public MovingMagnetizedBlock(QuarkModule module) {
        super("magnetized_block", module, null, BlockBehaviour.Properties.m_60939_((Material)Material.f_76283_).m_60978_(-1.0f).m_60988_().m_60993_().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_6810_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        MagnetizedBlockBlockEntity tile;
        if (state.m_60734_() != newState.m_60734_() && (tile = this.getMagnetTileEntity((BlockGetter)worldIn, pos)) != null) {
            tile.clearMagnetTileEntity();
        }
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (!worldIn.f_46443_ && worldIn.m_7702_(pos) == null) {
            worldIn.m_7471_(pos, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        MagnetizedBlockBlockEntity tile = this.getMagnetTileEntity((BlockGetter)builder.m_78962_(), (Vec3)builder.m_78970_(LootContextParams.f_81460_));
        return tile == null ? Collections.emptyList() : tile.getMagnetState().m_60724_(builder);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        MagnetizedBlockBlockEntity tile = this.getMagnetTileEntity(worldIn, pos);
        return tile != null ? tile.getCollisionShape(worldIn, pos) : Shapes.m_83040_();
    }

    @Nullable
    private MagnetizedBlockBlockEntity getMagnetTileEntity(BlockGetter world, Vec3 origin) {
        BlockPos pos = new BlockPos(origin);
        return this.getMagnetTileEntity(world, pos);
    }

    @Nullable
    private MagnetizedBlockBlockEntity getMagnetTileEntity(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof MagnetizedBlockBlockEntity ? (MagnetizedBlockBlockEntity)tile : null;
    }

    @Nonnull
    public ItemStack m_7397_(@Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public BlockState m_6843_(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(@Nonnull BlockState state, Mirror mirrorIn) {
        return this.m_6843_(state, mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return MovingMagnetizedBlock.createTickerHelper(type, MagnetsModule.magnetizedBlockType, MagnetizedBlockBlockEntity::tick);
    }
}

