/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.loaders;

import java.io.File;
import java.nio.file.Path;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.core.exceptions.IllegalTLauncherException;
import me.srrapero720.watermedia.loaders.ILoader;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FavricLoader
implements ClientModInitializer,
ILoader {
    private static final Marker IT = MarkerManager.getMarker((String)"FabricLoader");
    private final Path tempPath = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia");
    private final Path processPath = FabricLoader.getInstance().getGameDir();

    public void onInitializeClient() {
        try {
            if (this.tlcheck()) {
                throw new IllegalTLauncherException();
            }
            if (this.clientSide()) {
                WaterMedia.prepare(this).start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed starting WATERMeDIA for " + this.name() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public String name() {
        return "Fabric";
    }

    @Override
    public Path processDir() {
        return this.processPath;
    }

    @Override
    public Path tempDir() {
        return this.tempPath;
    }

    @Override
    public boolean developerMode() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public boolean clientSide() {
        return FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
    }

    @Override
    public boolean tlcheck() {
        String f = new File("").toPath().toAbsolutePath().toString().toLowerCase();
        boolean tlauncher = f.contains("tlauncher");
        boolean atlauncher = f.contains("atlauncher");
        boolean sklauncher = f.contains("skcraftlauncher");
        boolean keventlauncher = f.contains("keventlauncher");
        boolean tlskincape = FabricLoader.getInstance().isModLoaded("tlskincape") || FabricLoader.getInstance().isModLoaded("tlauncher_custom_cape_skin");
        return tlskincape || tlauncher && !atlauncher && !sklauncher && !keventlauncher;
    }
}

