/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.core.tools;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.image.decoders.GifDecoder;
import me.srrapero720.watermedia.core.tools.DataTool;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class JarTool {
    static final Marker IT = MarkerManager.getMarker((String)"Tools");
    private static final Gson GSON = new Gson();

    @Deprecated
    public static String readString(ClassLoader loader, String source) {
        try {
            byte[] bytes = DataTool.readAllBytes(JarTool.readResourceAsStream$byClassLoader(source, loader));
            return new String(bytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static boolean copyAsset(ClassLoader loader, String source, Path dest) {
        boolean bl;
        block10: {
            InputStream is = JarTool.readResourceAsStream$byClassLoader(source, loader);
            try {
                if (is == null) {
                    throw new FileNotFoundException("Resource was not found in " + source);
                }
                File destParent = dest.getParent().toFile();
                if (!destParent.exists() && !destParent.mkdirs()) {
                    WaterMedia.LOGGER.fatal(IT, "Cannot be created parent directories to {}", (Object)dest.toString());
                }
                Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    WaterMedia.LOGGER.fatal(IT, "Failed to extract from (JAR) {} to {} due to unexpected error", (Object)source, (Object)dest, (Object)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    @Deprecated
    public static List<String> readStringList(ClassLoader loader, String source) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader(JarTool.readResourceAsStream$byClassLoader(source, loader));){
            result.addAll((Collection)GSON.fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType()));
        }
        catch (Exception e) {
            WaterMedia.LOGGER.fatal(IT, "Exception trying to read JSON from {}", (Object)source, (Object)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static BufferedImage readImage(ClassLoader loader, String path) {
        try (InputStream in = JarTool.readResourceAsStream$byClassLoader(path, loader);){
            BufferedImage image = ImageIO.read(in);
            if (image == null) throw new FileNotFoundException("result of BufferedImage was null");
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading BufferedImage from resources", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static GifDecoder readGif(ClassLoader loader, String path) {
        try (BufferedInputStream in = new BufferedInputStream(JarTool.readResourceAsStream$byClassLoader(path, loader));){
            GifDecoder gif = new GifDecoder();
            int status = gif.read(in);
            if (status != 0) throw new IOException("Failed to process GIF - Decoder status: " + status);
            GifDecoder gifDecoder = gif;
            return gifDecoder;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading GIF from resources", e);
        }
    }

    public static String readString(String from) {
        String string;
        block8: {
            InputStream is = JarTool.readResourceAsStream(from);
            try {
                byte[] bytes = DataTool.readAllBytes(is);
                string = new String(bytes, Charset.defaultCharset());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public static boolean copyAsset(String origin, Path dest) {
        boolean bl;
        block10: {
            InputStream is = JarTool.readResourceAsStream(origin);
            try {
                if (is == null) {
                    throw new FileNotFoundException("Resource was not found in " + origin);
                }
                File destParent = dest.getParent().toFile();
                if (!destParent.exists() && !destParent.mkdirs()) {
                    WaterMedia.LOGGER.fatal(IT, "Cannot be created parent directories to {}", (Object)dest.toString());
                }
                Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    WaterMedia.LOGGER.fatal(IT, "Failed to extract from (JAR) {} to {} due to unexpected error", (Object)origin, (Object)dest, (Object)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static List<String> readStringList(String path) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader(JarTool.readResourceAsStream(path));){
            result.addAll((Collection)new Gson().fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType()));
        }
        catch (Exception e) {
            WaterMedia.LOGGER.fatal(IT, "Exception trying to read JSON from {}", (Object)path, (Object)e);
        }
        return result;
    }

    public static String[] readArrayAndParse(String path, Map<String, String> values) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(JarTool.readResourceAsStream(path)));){
            String[] keyset = values.keySet().toArray(new String[0]);
            String[] str = (String[])new Gson().fromJson((Reader)reader, new TypeToken<String[]>(){}.getType());
            for (int i = 0; i < str.length; ++i) {
                String v = str[i];
                for (String s : keyset) {
                    str[i] = v.replace("{" + s + "}", values.get(s));
                }
            }
            String[] stringArray = str;
            return stringArray;
        }
    }

    public static String[] readArray(String path) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(JarTool.readResourceAsStream(path)));){
            String[] stringArray = (String[])new Gson().fromJson((Reader)reader, new TypeToken<String[]>(){}.getType());
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage readImage(String path) {
        try (InputStream in = JarTool.readResourceAsStream(path);){
            BufferedImage image = ImageIO.read(in);
            if (image == null) throw new FileNotFoundException("result of BufferedImage was null");
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading BufferedImage from resources", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifDecoder readGif(String path) {
        try (BufferedInputStream in = new BufferedInputStream(JarTool.readResourceAsStream(path));){
            GifDecoder gif = new GifDecoder();
            int status = gif.read(in);
            if (status != 0) throw new IOException("Failed to process GIF - Decoder status: " + status);
            GifDecoder gifDecoder = gif;
            return gifDecoder;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading GIF from resources", e);
        }
    }

    public static InputStream readResourceAsStream(String source) {
        return JarTool.readResourceAsStream$byClassLoader(source, JarTool.class.getClassLoader());
    }

    private static InputStream readResourceAsStream$byClassLoader(String source, ClassLoader classLoader) {
        InputStream is = classLoader.getResourceAsStream(source);
        if (is == null && source.startsWith("/")) {
            is = classLoader.getResourceAsStream(source.substring(1));
        }
        return is;
    }

    public static URL readResource(String source) {
        return JarTool.readResource$byClassLoader(source, JarTool.class.getClassLoader());
    }

    private static URL readResource$byClassLoader(String source, ClassLoader classLoader) {
        URL is = classLoader.getResource(source);
        if (is == null && source.startsWith("/")) {
            is = classLoader.getResource(source.substring(1));
        }
        return is;
    }
}

