/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.image;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import me.srrapero720.watermedia.api.image.decoders.GifDecoder;
import me.srrapero720.watermedia.api.math.MathAPI;
import me.srrapero720.watermedia.api.rendering.RenderAPI;
import me.srrapero720.watermedia.core.tools.DataTool;

public class ImageRenderer {
    public final int width;
    public final int height;
    public final int[] textures;
    public final long[] delay;
    public final long duration;
    private ByteBuffer[] images;
    public boolean flushed;
    public int remaining;

    ImageRenderer(BufferedImage image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.images = new ByteBuffer[]{RenderAPI.getRawImageBuffer(image)};
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.textures = new int[]{-1};
        this.delay = new long[1];
        this.duration = 1L;
        this.remaining = this.images.length;
    }

    ImageRenderer(GifDecoder decoder) {
        if (decoder == null) {
            throw new NullPointerException();
        }
        this.images = RenderAPI.getRawImageBuffer(decoder.getFrames());
        this.width = decoder.getWidth();
        this.height = decoder.getHeight();
        this.textures = new int[decoder.getFrameCount()];
        this.delay = decoder.getDelayFrames();
        this.duration = decoder.getDuration();
        this.remaining = this.images.length;
        Arrays.fill(this.textures, -1);
    }

    public int texture(long time) {
        if (this.textures == null) {
            return 0;
        }
        if (this.textures.length == 1) {
            return this.texture(0);
        }
        for (int i = 0; i < this.delay.length; ++i) {
            if ((time -= this.delay[i]) > 0L) continue;
            return this.texture(i);
        }
        return this.texture(this.images.length - 1);
    }

    public int texture(int index) {
        if (this.textures[index] == -1) {
            this.textures[index] = RenderAPI.uploadBufferTexture(this.images[index], this.width, this.height);
            --this.remaining;
            if (this.remaining == 0) {
                this.flush();
            }
        }
        return this.textures[index];
    }

    public int texture(long tick, long deltaTime, boolean loop) {
        long time = tick * 50L + deltaTime;
        if (this.duration > 0L && time > this.duration && loop) {
            time %= this.duration;
        }
        return this.texture(time);
    }

    @Deprecated
    public int texture(int tick, long deltaTime, boolean loop) {
        long time = (long)tick * 50L + deltaTime;
        if (this.duration > 0L && time > this.duration && loop) {
            time %= this.duration;
        }
        return this.texture(time);
    }

    public int texture(long tick, float partialTicks, boolean loop) {
        return this.texture(tick, MathAPI.tickToMs(partialTicks), loop);
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    protected void flush() {
        if (this.flushed) {
            throw new IllegalStateException("Buffers are already flushed");
        }
        for (ByteBuffer buffer : this.images) {
            RenderAPI.freeByteBuffer(buffer);
        }
        this.images = new ByteBuffer[this.images.length];
        this.flushed = true;
    }

    public void reset() {
        if (!this.flushed) {
            throw new IllegalStateException("Buffers are not flushed");
        }
        this.remaining = this.images.length;
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i] = RenderAPI.getTextureBuffer(this.textures[i], this.width, this.height);
            RenderAPI.deleteTexture(this.textures);
            Arrays.fill(this.textures, -1);
        }
        this.flushed = false;
    }

    public void release() {
        if (this.flushed) {
            RenderAPI.deleteTexture(this.textures);
            Arrays.fill(this.textures, -1);
        } else {
            this.flush();
            RenderAPI.deleteTexture(DataTool.filterValue(this.textures, -1));
            Arrays.fill(this.textures, -1);
        }
    }

    static class Absolute
    extends ImageRenderer {
        Absolute(BufferedImage image) {
            super(image);
        }

        Absolute(GifDecoder decoder) {
            super(decoder);
        }

        @Override
        public void release() {
        }
    }
}

