/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.subtitles;

import java.util.regex.Pattern;

public class SubtitlesInfo {
    private static final Pattern fmtRegex = Pattern.compile("&fmt=[^&]*");
    private static final Pattern tlangRegex = Pattern.compile("&tlang=[^&]*");
    private final String url;
    private final String language;
    private final boolean isAutoGenerated;
    private final boolean fromCaptions;

    public SubtitlesInfo(String url, String language, boolean isAutoGenerated) {
        this(url, language, isAutoGenerated, false);
    }

    public SubtitlesInfo(String url, String language, boolean isAutoGenerated, boolean fromCaptions) {
        String filteredUrl = fmtRegex.matcher(url).replaceAll("");
        this.url = filteredUrl = tlangRegex.matcher(filteredUrl).replaceAll("");
        this.language = language;
        this.isAutoGenerated = isAutoGenerated;
        this.fromCaptions = fromCaptions;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isAutoGenerated() {
        return this.isAutoGenerated;
    }

    public boolean isFromCaptions() {
        return this.fromCaptions;
    }
}

