/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import me.lib720.caprica.vlcj.binding.lib.Kernel32;
import me.lib720.caprica.vlcj.binding.lib.LibC;
import me.lib720.caprica.vlcj.binding.lib.types.size_t;
import me.lib720.caprica.vlcj.player.embedded.videosurface.ByteBufferFactory;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;

final class NativeBuffers {
    private final boolean lockBuffers;
    private ByteBuffer[] nativeBuffers;
    private Pointer[] pointers;

    NativeBuffers(boolean lockBuffers) {
        this.lockBuffers = lockBuffers;
    }

    int allocate(BufferFormat bufferFormat) {
        int planeCount = bufferFormat.getPlaneCount();
        int[] pitchValues = bufferFormat.getPitches();
        int[] lineValues = bufferFormat.getLines();
        this.nativeBuffers = new ByteBuffer[planeCount];
        this.pointers = new Pointer[planeCount];
        for (int i = 0; i < planeCount; ++i) {
            ByteBuffer buffer;
            this.nativeBuffers[i] = buffer = ByteBufferFactory.allocateAlignedBuffer(pitchValues[i] * lineValues[i]);
            this.pointers[i] = Pointer.createConstant((long)ByteBufferFactory.getAddress(buffer));
            if (!this.lockBuffers) continue;
            if (!Platform.isWindows()) {
                LibC.INSTANCE.mlock(this.pointers[i], new NativeLong((long)buffer.capacity()));
                continue;
            }
            Kernel32.INSTANCE.VirtualLock(this.pointers[i], new size_t(buffer.capacity()));
        }
        return this.nativeBuffers.length;
    }

    void free() {
        if (this.nativeBuffers != null) {
            if (this.lockBuffers) {
                for (int i = 0; i < this.nativeBuffers.length; ++i) {
                    if (!Platform.isWindows()) {
                        LibC.INSTANCE.munlock(this.pointers[i], new NativeLong((long)this.nativeBuffers[i].capacity()));
                        continue;
                    }
                    Kernel32.INSTANCE.VirtualUnlock(this.pointers[i], new size_t(this.nativeBuffers[i].capacity()));
                }
            }
            this.nativeBuffers = null;
            this.pointers = null;
        }
    }

    ByteBuffer[] buffers() {
        return this.nativeBuffers;
    }

    Pointer[] pointers() {
        return this.pointers;
    }
}

