/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.base;

import me.lib720.caprica.vlcj.media.MediaEventListener;
import me.lib720.caprica.vlcj.player.base.BaseApi;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;
import me.lib720.caprica.vlcj.player.base.MediaPlayerEventListener;
import me.lib720.caprica.vlcj.player.base.MediaPlayerNativeEventManager;
import me.lib720.caprica.vlcj.player.base.MediaPlayerReadyEventHandler;
import me.lib720.caprica.vlcj.player.base.RepeatPlayEventHandler;
import me.lib720.caprica.vlcj.player.base.ResetMediaEventHandler;
import me.lib720.caprica.vlcj.player.base.events.MediaPlayerEvent;

public final class EventApi
extends BaseApi {
    private final MediaPlayerNativeEventManager eventManager;

    EventApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
        this.eventManager = new MediaPlayerNativeEventManager(this.libvlcInstance, mediaPlayer);
        this.addMediaPlayerEventListener(new ResetMediaEventHandler());
        this.addMediaPlayerEventListener(new RepeatPlayEventHandler());
        this.addMediaPlayerEventListener(new MediaPlayerReadyEventHandler());
    }

    public void addMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.eventManager.addEventListener(listener);
    }

    public void removeMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.eventManager.removeEventListener(listener);
    }

    public void addMediaEventListener(MediaEventListener listener) {
        this.mediaPlayer.media().addPersistentMediaEventListener(listener);
    }

    public void removeMediaEventListener(MediaEventListener listener) {
        this.mediaPlayer.media().removePersistentMediaEventListener(listener);
    }

    void raiseEvent(MediaPlayerEvent event) {
        this.eventManager.raiseEvent(event);
    }

    @Override
    protected void release() {
        this.eventManager.release();
    }
}

