/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.factory;

import java.util.ArrayList;
import java.util.List;
import me.lib720.caprica.vlcj.VideoLan4J;
import me.lib720.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.factory.AudioOutput;
import me.lib720.caprica.vlcj.factory.BaseApi;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.player.base.AudioDevice;

public final class AudioApi
extends BaseApi {
    AudioApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public List<AudioOutput> audioOutputs() {
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutputs = LibVlc.libvlc_audio_output_list_get(this.libvlcInstance);
        if (audioOutputs != null) {
            libvlc_audio_output_t audioOutput = audioOutputs;
            while (audioOutput != null) {
                String name = VideoLan4J.copyNativeString(audioOutput.psz_name);
                String description = VideoLan4J.copyNativeString(audioOutput.psz_description);
                result.add(new AudioOutput(name, description, this.getAudioOutputDevices(name)));
                audioOutput = audioOutput.p_next;
            }
            LibVlc.libvlc_audio_output_list_release(audioOutputs.getPointer());
        }
        return result;
    }

    private List<AudioDevice> getAudioOutputDevices(String outputName) {
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = LibVlc.libvlc_audio_output_device_list_get(this.libvlcInstance, outputName);
        if (audioDevices != null) {
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = VideoLan4J.copyNativeString(audioDevice.psz_device);
                String description = VideoLan4J.copyNativeString(audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            LibVlc.libvlc_audio_output_device_list_release(audioDevices.getPointer());
        }
        return result;
    }
}

