/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.apache.compress.compressors.lzma;

import java.io.IOException;
import java.io.InputStream;
import me.lib720.apache.compress.MemoryLimitException;
import me.lib720.apache.compress.compressors.CompressorInputStream;
import me.lib720.apache.compress.utils.InputStreamStatistics;
import me.lib720.apache.io.IOUtils;
import me.lib720.apache.io.input.CountingInputStream;
import me.lib720.tukaani.xz.LZMAInputStream;

public class LZMACompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public static boolean matches(byte[] signature, int length) {
        return signature != null && length >= 3 && signature[0] == 93 && signature[1] == 0 && signature[2] == 0;
    }

    public LZMACompressorInputStream(InputStream inputStream) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = new LZMAInputStream((InputStream)this.countingStream, -1);
    }

    public LZMACompressorInputStream(InputStream inputStream, int memoryLimitInKb) throws IOException {
        try {
            this.countingStream = new CountingInputStream(inputStream);
            this.in = new LZMAInputStream((InputStream)this.countingStream, memoryLimitInKb);
        }
        catch (me.lib720.tukaani.xz.MemoryLimitException e) {
            throw new MemoryLimitException(e.getMemoryNeeded(), e.getMemoryLimit(), e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getByteCount();
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        this.count(ret == -1 ? 0 : 1);
        return ret;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        this.count(ret);
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        return IOUtils.skip(this.in, n);
    }
}

