/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import shadows.hostilenetworks.client.WeirdRenderThings;
import shadows.hostilenetworks.client.WrappedRTBuffer;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.gui.DeepLearnerContainer;
import shadows.hostilenetworks.util.ReflectionThings;
import shadows.placebo.screen.PlaceboContainerScreen;
import shadows.placebo.screen.TickableText;

public class DeepLearnerScreen
extends PlaceboContainerScreen<DeepLearnerContainer> {
    public static final int WIDTH = 338;
    public static final int HEIGHT = 235;
    private static final ResourceLocation BASE = new ResourceLocation("hostilenetworks", "textures/gui/deep_learner.png");
    private static final ResourceLocation PLAYER = new ResourceLocation("hostilenetworks", "textures/gui/default_gui.png");
    private List<TickableText> texts = new ArrayList<TickableText>();
    private TickableText stats = new TickableText(I18n.m_118938_((String)"hostilenetworks.gui.stats", (Object[])new Object[0]), 6478079);
    private final String[] statArray = new String[3];
    private int numModels = 0;
    private boolean emptyText = true;
    private CachedModel[] models = new CachedModel[4];
    private int spin = 0;
    private int selectedModel = 0;
    private ImageButton btnLeft;
    private ImageButton btnRight;
    private int variant = 0;
    private int ticksShown = 0;
    private static DecimalFormat fmt = new DecimalFormat("##.##%");

    public DeepLearnerScreen(DeepLearnerContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 338;
        this.f_97727_ = 235;
        this.setupEmptyText();
        pMenu.setNotifyCallback(slotId -> {
            ItemStack stack = pMenu.m_38853_((int)slotId).m_7993_();
            CachedModel old = this.models[slotId];
            CachedModel cachedModel = this.models[slotId.intValue()] = stack.m_41619_() ? null : new CachedModel(stack, (int)slotId);
            if (old == null && this.models[slotId] != null) {
                if (++this.numModels == 1) {
                    this.selectedModel = slotId;
                    this.setupModel(this.getCurrentModel());
                    this.emptyText = false;
                }
            } else if (old != null && this.models[slotId] == null) {
                --this.numModels;
                if (this.numModels > 0 && slotId == this.selectedModel) {
                    this.selectLeft();
                }
            } else if (slotId == this.selectedModel && this.models[this.selectedModel] != null) {
                this.setupModel(this.models[this.selectedModel]);
            }
        });
    }

    protected CachedModel getCurrentModel() {
        return this.models[this.selectedModel];
    }

    public void m_7856_() {
        super.m_7856_();
        this.btnLeft = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() - 27, this.getGuiTop() + 105, 24, 24, 84, 140, 24, BASE, btn -> this.selectLeft()));
        this.btnRight = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() - 1, this.getGuiTop() + 105, 24, 24, 108, 140, 24, BASE, btn -> this.selectRight()));
    }

    public void selectLeft() {
        if (this.numModels == 0) {
            return;
        }
        int old = this.selectedModel;
        CachedModel model = this.models[this.clamp(this.selectedModel - 1)];
        while (model == null) {
            model = this.models[this.clamp(this.selectedModel - 1)];
        }
        if (model.getSlot() != old) {
            this.setupModel(model);
        }
    }

    public void selectRight() {
        if (this.numModels == 0) {
            return;
        }
        int old = this.selectedModel;
        CachedModel model = this.models[this.clamp(this.selectedModel + 1)];
        while (model == null) {
            model = this.models[this.clamp(this.selectedModel + 1)];
        }
        if (model.getSlot() != old) {
            this.setupModel(model);
        }
    }

    private int clamp(int idx) {
        if (idx == -1) {
            idx = 3;
        }
        if (idx == 4) {
            idx = 0;
        }
        this.selectedModel = idx;
        return this.selectedModel;
    }

    protected void m_7286_(PoseStack matrix, float pPartialTicks, int pX, int pY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BASE);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.m_93228_(matrix, left + 41, top, 0, 0, 256, 140);
        if (this.numModels > 0) {
            for (int i = 0; i < 3; ++i) {
                int n = left + 338 - 49 - this.stats.getWidth(this.f_96547_);
                Objects.requireNonNull(this.f_96547_);
                Objects.requireNonNull(this.f_96547_);
                this.m_93228_(matrix, n, top + 8 + 9 + (9 + 2) * i, 0, 140 + 9 * i, 9, 9);
            }
            this.m_93228_(matrix, left - 41, top, 9, 140, 75, 101);
            CachedModel model = this.getCurrentModel();
            if (model != null && model.isValid()) {
                LivingEntity ent = model.getEntity((Level)this.f_96541_.f_91073_, this.variant);
                ent.f_20883_ = this.spin % 360;
                this.renderEntityInInventory(left - 4, top + 90, 40.0f, 0.0f, 0.0f, ent);
            }
            for (int i = 0; i < 3; ++i) {
                String string = this.statArray[i];
                float f = left + 338 - 36 - this.stats.getWidth(this.f_96547_);
                Objects.requireNonNull(this.f_96547_);
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92883_(matrix, string, f, (float)(top + 9 + 9 + (9 + 2) * i), 0xFFFFFF);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)PLAYER);
        this.m_93228_(matrix, left + 81, top + 145, 0, 0, 176, 90);
        if (this.numModels <= 1) {
            this.btnLeft.f_93624_ = false;
            this.btnRight.f_93624_ = false;
        } else {
            this.btnLeft.f_93624_ = true;
            this.btnRight.f_93624_ = true;
        }
    }

    protected void m_7027_(PoseStack stack, int pX, int pY) {
        int left = 49;
        int top = 6;
        Objects.requireNonNull(this.f_96547_);
        int spacing = 9 + 3;
        int idx = 0;
        for (TickableText t : this.texts) {
            t.render(this.f_96547_, stack, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 49;
                continue;
            }
            left += t.getWidth(this.f_96547_);
        }
        if (this.numModels > 0) {
            this.stats.render(this.f_96547_, stack, 289 - this.stats.getWidth(this.f_96547_), top);
        }
    }

    public void m_181908_() {
        int i;
        block5: {
            block4: {
                if (((DeepLearnerContainer)this.f_97732_).hasModels()) break block4;
                if (this.emptyText) break block5;
                this.setupEmptyText();
                this.emptyText = true;
                break block5;
            }
            if (this.emptyText) {
                for (i = 0; i < 4; ++i) {
                    if (this.models[i] == null) continue;
                    this.setupModel(this.models[i]);
                    this.selectedModel = i;
                    this.emptyText = false;
                    break;
                }
            }
        }
        for (i = 0; i < this.texts.size(); ++i) {
            TickableText txt = this.texts.get(i);
            if (txt.isDone()) continue;
            txt.tick();
            break;
        }
        this.stats.tick();
        ++this.spin;
        if (++this.ticksShown % 80 == 0) {
            this.nextVariant();
        }
    }

    private void nextVariant() {
        CachedModel current = this.getCurrentModel();
        if (current == null || !current.isValid()) {
            return;
        }
        int variants = current.getModel().getSubtypes().size();
        if (variants == 0) {
            return;
        }
        this.variant = (this.variant + 1) % (variants + 1);
        LivingEntity entity = current.getEntity((Level)this.f_96541_.f_91073_, this.variant);
        if (this.variant == 0) {
            this.texts.set(1, new TickableText(entity.m_6095_().m_20676_().getString(), 0xFFFFFF, true, 2.0f).setTicks(9999));
        } else {
            this.texts.set(1, new TickableText(I18n.m_118938_((String)"hostilenetworks.gui.variant", (Object[])new Object[]{entity.m_6095_().m_20676_().getString()}), 65472, true, 2.0f).setTicks(9999));
        }
    }

    private void setupEmptyText() {
        this.resetText();
        for (int i = 0; i < 7; ++i) {
            this.addText(I18n.m_118938_((String)("hostilenetworks.gui.learner_empty." + i), (Object[])new Object[0]), i == 0 ? 6478079 : 0xFFFFFF);
        }
    }

    private void setupModel(CachedModel cache) {
        int i;
        if (cache == null || !cache.isValid()) {
            return;
        }
        DataModel model = cache.getModel();
        this.ticksShown = 0;
        this.variant = 0;
        this.resetText();
        this.addText(I18n.m_118938_((String)"hostilenetworks.gui.name", (Object[])new Object[0]), 6478079);
        this.addText(cache.getEntity((Level)this.f_96541_.f_91073_).m_6095_().m_20676_().getString(), 0xFFFFFF);
        this.addText(I18n.m_118938_((String)"hostilenetworks.gui.info", (Object[])new Object[0]), 6478079);
        String[] trivia = I18n.m_118938_((String)model.getTriviaKey(), (Object[])new Object[0]).split("\\n");
        for (i = 0; i < Math.min(4, trivia.length); ++i) {
            this.addText(trivia[i], 0xFFFFFF);
        }
        for (i = trivia.length; i < 5; ++i) {
            this.addText("", 0);
        }
        this.addText(I18n.m_118938_((String)"hostilenetworks.gui.tier", (Object[])new Object[0]), 0xFFFFFF, false);
        ModelTier tier = cache.getTier();
        ModelTier next = tier.next();
        this.addText(I18n.m_118938_((String)("hostilenetworks.tier." + tier.name), (Object[])new Object[0]), tier.color.m_126665_());
        this.addText(I18n.m_118938_((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]), 0xFFFFFF, false);
        this.addText(fmt.format(cache.getAccuracy()), tier.color.m_126665_());
        if (tier != next) {
            this.addText(I18n.m_118938_((String)"hostilenetworks.gui.next_tier", (Object[])new Object[0]), 0xFFFFFF, false);
            this.addText(I18n.m_118938_((String)("hostilenetworks.tier." + next.name), (Object[])new Object[0]), next.color.m_126665_(), false);
            this.addText(I18n.m_118938_((String)"hostilenetworks.gui.next_tier2", (Object[])new Object[]{cache.getKillsNeeded()}), 0xFFFFFF, false);
            this.addText(I18n.m_118938_((String)("hostilenetworks.gui.kill" + (cache.getKillsNeeded() > 1 ? "s" : "")), (Object[])new Object[0]), 0xFFFFFF);
        } else {
            this.addText(I18n.m_118938_((String)"hostilenetworks.gui.max_tier", (Object[])new Object[0]), ChatFormatting.RED.m_126665_());
        }
        LivingEntity ent = cache.getEntity((Level)this.f_96541_.f_91073_);
        if (ent == null) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.statArray[i2] = "\u00a7k99999";
            }
        }
        this.statArray[0] = String.valueOf((int)(ent.m_21051_(Attributes.f_22276_).m_22115_() / 2.0));
        this.statArray[1] = String.valueOf((int)(ent.m_21051_(Attributes.f_22284_).m_22115_() / 2.0));
        this.statArray[2] = String.valueOf(ReflectionThings.getExperienceReward(ent, ((DeepLearnerContainer)this.f_97732_).player));
    }

    private void addText(String msg, int color) {
        this.texts.add(new TickableText(msg, color, true, 2.0f));
    }

    private void addText(String msg, int color, boolean newline) {
        this.texts.add(new TickableText(msg, color, newline, 2.0f));
    }

    private void resetText() {
        this.texts.clear();
        this.stats.reset();
    }

    public void renderEntityInInventory(float pPosX, float pPosY, float pScale, float pMouseX, float pMouseY, LivingEntity pLivingEntity) {
        float f1 = (float)Math.atan(pMouseY / 40.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)pPosX, (double)pPosY, 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack matrixstack = new PoseStack();
        matrixstack.m_85837_(0.0, 0.0, 1000.0);
        DataModel model = this.getCurrentModel().getModel();
        matrixstack.m_85841_(pScale *= model.getScale(), pScale, pScale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(f1 * 20.0f);
        quaternion.m_80148_(quaternion1);
        matrixstack.m_85845_(quaternion);
        matrixstack.m_85845_(Vector3f.f_122225_.m_122240_(((float)this.spin + this.f_96541_.m_91297_()) * 2.25f % 360.0f));
        pLivingEntity.m_146922_(0.0f);
        pLivingEntity.f_20883_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20885_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20886_ = pLivingEntity.m_146908_();
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        entityrenderermanager.m_114412_(quaternion1);
        entityrenderermanager.m_114468_(false);
        MultiBufferSource.BufferSource rtBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        WeirdRenderThings.fullbright_gui = true;
        RenderSystem.m_69890_(() -> entityrenderermanager.m_114384_((Entity)pLivingEntity, (double)model.getXOffset(), (double)model.getYOffset(), (double)model.getZOffset(), 0.0f, 1.0f, matrixstack, (MultiBufferSource)new WrappedRTBuffer((MultiBufferSource)rtBuffer), 0xF000F0));
        rtBuffer.m_109911_();
        WeirdRenderThings.fullbright_gui = false;
        entityrenderermanager.m_114468_(true);
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }
}

