/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.type.DispJVMKt;
import org.kodein.type.TypeStringer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/kodein/type/SimpleTypeStringer;", "Lorg/kodein/type/TypeStringer;", "()V", "arrayTypeName", "", "getArrayTypeName", "()Ljava/lang/String;", "dispName", "cls", "Ljava/lang/Class;", "skipStars", "", "kodein-type"})
final class SimpleTypeStringer
extends TypeStringer {
    @NotNull
    public static final SimpleTypeStringer INSTANCE = new SimpleTypeStringer();

    private SimpleTypeStringer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String dispName(@NotNull Class<?> cls, boolean skipStars) {
        String string;
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        if (cls.isArray()) {
            if (cls.getComponentType().isPrimitive()) {
                Class<?> clazz = cls.getComponentType();
                if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
                    return "BooleanArray";
                }
                if (Intrinsics.areEqual(clazz, Byte.TYPE)) {
                    return "ByteArray";
                }
                if (Intrinsics.areEqual(clazz, Character.TYPE)) {
                    return "CharArray";
                }
                if (Intrinsics.areEqual(clazz, Short.TYPE)) {
                    return "ShortArray";
                }
                if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
                    return "IntArray";
                }
                if (Intrinsics.areEqual(clazz, Long.TYPE)) {
                    return "LongArray";
                }
                if (Intrinsics.areEqual(clazz, Float.TYPE)) {
                    return "FloatArray";
                }
                if (Intrinsics.areEqual(clazz, Double.TYPE)) {
                    return "DoubleArray";
                }
                String string2 = Intrinsics.stringPlus((String)"Unknown primitive type ", (Object)this);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            StringBuilder stringBuilder = new StringBuilder().append("Array<");
            TypeStringer typeStringer = this;
            Class<?> clazz = cls.getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"cls.componentType");
            string = stringBuilder.append(TypeStringer.dispString$default(typeStringer, clazz, false, 2, null)).append('>').toString();
            return string;
        } else {
            String string3 = DispJVMKt.access$getPrimitiveName(cls);
            string = string3 == null ? Intrinsics.stringPlus((String)DispJVMKt.simpleErasedName(cls), (Object)(!skipStars ? DispJVMKt.access$getStars(cls) : "")) : string3;
        }
        return string;
    }

    @Override
    @NotNull
    public String getArrayTypeName() {
        return "Array";
    }
}

