/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.impl;

import gg.essential.vigilance.data.Migration;
import gg.essential.vigilance.impl.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u001aD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u001a\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003H\u0000\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a'\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u0014*\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u001a\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b*\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"META_KEY", "", "VERSION_KEY", "", "applyMigration", "", "root", "Lgg/essential/vigilance/impl/nightconfig/core/Config;", "migration", "", "oldMap", "", "", "newMap", "migrate", "migrations", "Lgg/essential/vigilance/data/Migration;", "migrationLogKey", "rollbackMigration", "purge", "T", "keys", "(Lgg/essential/vigilance/impl/nightconfig/core/Config;Ljava/util/List;)Ljava/lang/Object;", "toMap", "Vigilance"})
public final class MigrationKt {
    @NotNull
    private static final String META_KEY = "__meta";
    @NotNull
    private static final List<String> VERSION_KEY;

    private static final List<String> migrationLogKey(int migration) {
        Object[] objectArray = new String[]{META_KEY, "migration_log", String.valueOf(migration)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static final void migrate(@NotNull Config root, @NotNull List<? extends Migration> migrations) {
        int fileVersion;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
        Integer n = (Integer)root.get(VERSION_KEY);
        int n2 = fileVersion = n != null ? n : 0;
        if (fileVersion < migrations.size()) {
            Map oldMap = MigrationKt.toMap(root);
            int n3 = migrations.size();
            for (int migration = fileVersion; migration < n3; ++migration) {
                Map newMap = MapsKt.toMutableMap(oldMap);
                migrations.get(migration).apply(newMap);
                MigrationKt.applyMigration(root, migration, oldMap, newMap);
                root.update(VERSION_KEY, (Object)(migration + 1));
                oldMap = newMap;
                boolean bl = Intrinsics.areEqual((Object)oldMap, MigrationKt.toMap(root));
                if (!_Assertions.ENABLED || bl) continue;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        } else if (fileVersion > migrations.size()) {
            int migration = fileVersion - 1;
            int n4 = migrations.size();
            if (n4 <= migration) {
                while (true) {
                    MigrationKt.rollbackMigration(root, migration);
                    root.update(VERSION_KEY, (Object)migration);
                    if (migration == n4) break;
                    --migration;
                }
            }
        }
    }

    private static final void applyMigration(Config root, int migration, Map<String, ? extends Object> oldMap, Map<String, ? extends Object> newMap) {
        Object newValue;
        Config migrationLog = root.createSubConfig();
        for (Map.Entry<String, ? extends Object> object : oldMap.entrySet()) {
            String string = object.getKey();
            Object oldValue = object.getValue();
            Object[] objectArray = newMap;
            if (!objectArray.containsKey(string)) {
                Object[] objectArray2 = new String[]{"changed", string};
                migrationLog.update(CollectionsKt.listOf((Object[])objectArray2), oldValue);
                objectArray2 = new String[]{"."};
                MigrationKt.purge(root, StringsKt.split$default((CharSequence)string, (String[])objectArray2, (boolean)false, (int)0, (int)6, null));
                continue;
            }
            newValue = newMap.get(string);
            if (Intrinsics.areEqual(newValue, (Object)oldValue)) continue;
            objectArray = new String[]{"changed", string};
            migrationLog.update(CollectionsKt.listOf((Object[])objectArray), oldValue);
            root.update(string, newValue);
        }
        List added = new ArrayList();
        for (Map.Entry entry : newMap.entrySet()) {
            String key = (String)entry.getKey();
            newValue = entry.getValue();
            Map<String, ? extends Object> map2 = oldMap;
            if (map2.containsKey(key)) continue;
            added.add(key);
            root.update(key, newValue);
        }
        if (!((Collection)added).isEmpty()) {
            migrationLog.update(CollectionsKt.listOf((Object)"added"), (Object)added);
        }
        if (!migrationLog.isEmpty()) {
            root.update(MigrationKt.migrationLogKey(migration), (Object)migrationLog);
        }
    }

    private static final void rollbackMigration(Config root, int migration) {
        Config config = (Config)MigrationKt.purge(root, MigrationKt.migrationLogKey(migration));
        if (config == null) {
            return;
        }
        Config migrationLog = config;
        List list = (List)migrationLog.get(CollectionsKt.listOf((Object)"added"));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List added = list;
        Config config2 = (Config)migrationLog.get(CollectionsKt.listOf((Object)"changed"));
        Map map2 = config2 != null ? config2.valueMap() : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map changed = map2;
        for (String entry : added) {
            String[] stringArray = new String[]{"."};
            MigrationKt.purge(root, StringsKt.split$default((CharSequence)entry, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        for (Map.Entry entry : changed.entrySet()) {
            String key = (String)entry.getKey();
            Object oldValue = entry.getValue();
            root.update(key, oldValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> T purge(Config $this$purge, List<String> keys) {
        Object t;
        if (keys.size() > 1) {
            void var3_4;
            Object t3 = $this$purge.get(CollectionsKt.listOf((Object)keys.get(0)));
            Config config = t3 instanceof Config ? (Config)t3 : null;
            if (config == null) {
                return null;
            }
            Config child = config;
            T removed = MigrationKt.purge(child, keys.subList(1, keys.size()));
            if (child.isEmpty()) {
                $this$purge.remove(CollectionsKt.listOf((Object)keys.get(0)));
            }
            t = var3_4;
        } else {
            t = $this$purge.remove(keys);
        }
        return t;
    }

    private static final Map<String, Object> toMap(Config $this$toMap) {
        Map result = new LinkedHashMap();
        MigrationKt.toMap$visit(result, $this$toMap, "");
        return result;
    }

    private static final void toMap$visit(Map<String, Object> result, Config config, String prefix) {
        Map<String, Object> map2 = config.valueMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"valueMap(...)");
        Map<String, Object> object2 = map2;
        for (Map.Entry<String, Object> entry : object2.entrySet()) {
            String key = entry.getKey();
            Object value2 = entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)META_KEY)) continue;
            if (value2 instanceof Config) {
                MigrationKt.toMap$visit(result, (Config)value2, prefix + key + '.');
                continue;
            }
            result.put(prefix + key, value2);
        }
    }

    static {
        Object[] objectArray = new String[]{META_KEY, "version"};
        VERSION_KEY = CollectionsKt.listOf((Object[])objectArray);
    }
}

