/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util.image.mask.impl;

import gg.essential.util.image.mask.Mask;
import gg.essential.util.image.mask.MutableMask;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u0019\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J(\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006#"}, d2={"Lgg/essential/util/image/mask/impl/LongArrayMask;", "Lgg/essential/util/image/mask/MutableMask;", "width", "", "height", "(II)V", "data", "", "(II[J)V", "getHeight", "()I", "getWidth", "checkCompatible", "mask", "Lgg/essential/util/image/mask/Mask;", "clear", "", "x", "y", "w", "h", "count", "equals", "", "other", "", "fixFinalLong", "get", "hashCode", "inv", "mutableCopy", "set", "setAnd", "setOr", "Companion", "utils"})
@SourceDebugExtension(value={"SMAP\nLongArrayMask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongArrayMask.kt\ngg/essential/util/image/mask/impl/LongArrayMask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class LongArrayMask
implements MutableMask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final long[] data;
    private static final int BPL = 6;
    private static final int INDEX_MASK = 63;

    public LongArrayMask(int width2, int height2, @NotNull long[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.width = width2;
        this.height = height2;
        this.data = data;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public LongArrayMask(int width2, int height2) {
        this(width2, height2, new long[(width2 * height2 + 63) / 64]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int count() {
        long[] lArray = this.data;
        int n = 0;
        int n2 = lArray.length;
        for (int j = 0; j < n2; ++j) {
            void it;
            long l;
            long l2 = l = lArray[j];
            int n3 = n;
            boolean bl = false;
            int n4 = Long.bitCount((long)it);
            n = n3 + n4;
        }
        return n;
    }

    @Override
    public boolean get(int x, int y) {
        int bitIndex;
        int index2 = y * this.getWidth() + x;
        int longIndex = index2 >> 6;
        return (this.data[longIndex] >> (bitIndex = index2 & 0x3F) & 1L) == 1L;
    }

    @Override
    public void set(int x, int y) {
        int index2 = y * this.getWidth() + x;
        int longIndex = index2 >> 6;
        int bitIndex = index2 & 0x3F;
        this.data[longIndex] = this.data[longIndex] | 1L << bitIndex;
    }

    @Override
    public void clear(int x, int y) {
        int index2 = y * this.getWidth() + x;
        int longIndex = index2 >> 6;
        int bitIndex = index2 & 0x3F;
        this.data[longIndex] = this.data[longIndex] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void set(int x, int y, int w, int h) {
        if (w == this.getWidth() && h == this.getHeight()) {
            ArraysKt.fill$default((long[])this.data, (long)-1L, (int)0, (int)0, (int)6, null);
            this.fixFinalLong();
            return;
        }
        MutableMask.DefaultImpls.set(this, x, y, w, h);
    }

    @Override
    public void clear(int x, int y, int w, int h) {
        if (w == this.getWidth() && h == this.getHeight()) {
            ArraysKt.fill$default((long[])this.data, (long)0L, (int)0, (int)0, (int)6, null);
            return;
        }
        MutableMask.DefaultImpls.clear(this, x, y, w, h);
    }

    @Override
    public void inv() {
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.data[i2] = this.data[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.fixFinalLong();
    }

    private final void fixFinalLong() {
        int index2 = this.getWidth() * this.getHeight();
        int longIndex = index2 >> 6;
        int bitIndex = index2 & 0x3F;
        if (bitIndex == 0) {
            return;
        }
        this.data[longIndex] = this.data[longIndex] & -1L >>> 64 - bitIndex;
    }

    private final LongArrayMask checkCompatible(Mask mask) {
        if (!(this.getWidth() == mask.getWidth())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.getHeight() == mask.getHeight())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return mask instanceof LongArrayMask ? (LongArrayMask)mask : LongArrayMask.Companion.intoLongArrayMask(mask);
    }

    @Override
    public void setOr(@NotNull Mask other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long[] otherData = this.checkCompatible((Mask)other).data;
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.data[i2] = this.data[i2] | otherData[i2];
        }
    }

    @Override
    public void setAnd(@NotNull Mask other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long[] otherData = this.checkCompatible((Mask)other).data;
        int n = this.data.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.data[i2] = this.data[i2] & otherData[i2];
        }
    }

    @Override
    @NotNull
    public MutableMask mutableCopy() {
        return new LongArrayMask(this.getWidth(), this.getHeight(), (long[])this.data.clone());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mask)) {
            return false;
        }
        if (this.getWidth() != ((Mask)other).getWidth()) {
            return false;
        }
        if (this.getHeight() != ((Mask)other).getHeight()) {
            return false;
        }
        long[] otherData = other instanceof LongArrayMask ? ((LongArrayMask)other).data : ((Companion)LongArrayMask.Companion).intoLongArrayMask((Mask)((Mask)other)).data;
        return Arrays.equals(this.data, otherData);
    }

    public int hashCode() {
        int result = this.getWidth();
        result = 31 * result + this.getHeight();
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public void set(int x, int y, boolean value2) {
        MutableMask.DefaultImpls.set(this, x, y, value2);
    }

    @Override
    public void set(int x, int y, int w, int h, boolean value2) {
        MutableMask.DefaultImpls.set(this, x, y, w, h, value2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgg/essential/util/image/mask/impl/LongArrayMask$Companion;", "", "()V", "BPL", "", "INDEX_MASK", "intoLongArrayMask", "Lgg/essential/util/image/mask/impl/LongArrayMask;", "mask", "Lgg/essential/util/image/mask/Mask;", "utils"})
    public static final class Companion {
        private Companion() {
        }

        private final LongArrayMask intoLongArrayMask(Mask mask) {
            LongArrayMask result = new LongArrayMask(mask.getWidth(), mask.getHeight());
            int n = mask.getHeight();
            for (int y = 0; y < n; ++y) {
                int n2 = mask.getWidth();
                for (int x = 0; x < n2; ++x) {
                    result.set(x, y, mask.get(x, y));
                }
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

