/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import gg.essential.util.JsonHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class WebUtil {
    public static boolean LOG = false;

    public static JsonHolder fetchJSON(String url) {
        return new JsonHolder(WebUtil.fetchString(url));
    }

    public static String fetchString(String url) {
        String string;
        block9: {
            url = url.replace(" ", "%20");
            if (LOG) {
                Essential.logger.debug("Fetching {}", (Object)url);
            }
            InputStream setup2 = WebUtil.setup(url, "Mozilla/4.76 (Essential)");
            try {
                string = IOUtils.toString((InputStream)setup2, (Charset)Charset.defaultCharset());
                if (setup2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (setup2 != null) {
                        try {
                            setup2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Essential.logger.error("Failed to fetch from {}", (Object)url, (Object)e);
                    return "Failed to fetch";
                }
            }
            setup2.close();
        }
        return string;
    }

    public static byte[] downloadToBytes(String url, String userAgent) throws IOException {
        try (InputStream in = WebUtil.setup(url, userAgent);){
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
    }

    public static void downloadToFile(String url, File file, String userAgent) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);
             BufferedInputStream in = new BufferedInputStream(WebUtil.setup(url, userAgent));){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                outputStream.write(dataBuffer, 0, bytesRead);
            }
        }
    }

    public static InputStream setup(String url, String userAgent) throws IOException {
        URL u = new URL(url);
        URLConnection connection = u.openConnection();
        connection.setUseCaches(true);
        connection.addRequestProperty("User-Agent", userAgent);
        connection.setReadTimeout(15000);
        connection.setConnectTimeout(15000);
        connection.setDoOutput(true);
        return connection.getInputStream();
    }
}

