/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.pingproxy;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.pingproxy.ClientPingProxyPacket;
import gg.essential.connectionmanager.common.packet.pingproxy.ServerPingProxyResponsePacket;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import gg.essential.network.connectionmanager.ConnectionManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\r\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ0\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\u0002\b\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lgg/essential/network/pingproxy/ProxyPingPacketHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/buffer/ByteBuf;", "Lnet/minecraft/client/multiplayer/ServerData;", "serverData", "<init>", "(Lnet/minecraft/client/multiplayer/ServerData;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "", "channelActive", "(Lio/netty/channel/ChannelHandlerContext;)V", "msg", "channelRead0", "(Lio/netty/channel/ChannelHandlerContext;Lio/netty/buffer/ByteBuf;)V", "", "id", "Lkotlin/Function1;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lkotlin/ExtensionFunctionType;", "writer", "sendPacket", "(ILkotlin/jvm/functions/Function1;)V", "Lio/netty/channel/Channel;", "channel", "Lio/netty/channel/Channel;", "getChannel", "()Lio/netty/channel/Channel;", "setChannel", "(Lio/netty/channel/Channel;)V", "", "isQuery", "Z", "Lgg/essential/connectionmanager/common/packet/pingproxy/ClientPingProxyPacket;", "pingData", "Lgg/essential/connectionmanager/common/packet/pingproxy/ClientPingProxyPacket;", "Lnet/minecraft/client/multiplayer/ServerData;", "getServerData", "()Lnet/minecraft/client/multiplayer/ServerData;", "Essential 1.18.2-forge"})
public final class ProxyPingPacketHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    @NotNull
    private final ServerData serverData;
    private boolean isQuery;
    @Nullable
    private ClientPingProxyPacket pingData;
    public Channel channel;

    public ProxyPingPacketHandler(@NotNull ServerData serverData) {
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        this.serverData = serverData;
    }

    @NotNull
    public final ServerData getServerData() {
        return this.serverData;
    }

    @NotNull
    public final Channel getChannel() {
        Channel channel2 = this.channel;
        if (channel2 != null) {
            return channel2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        return null;
    }

    public final void setChannel(@NotNull Channel channel2) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"<set-?>");
        this.channel = channel2;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Channel channel2 = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"channel(...)");
        this.setChannel(channel2);
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @NotNull ByteBuf msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        FriendlyByteBuf buf = new FriendlyByteBuf(msg);
        int id2 = buf.m_130242_();
        if (!this.isQuery) {
            if (id2 == 0) {
                int protocolVersion = buf.m_130242_();
                String string = buf.m_130136_(255);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUtf(...)");
                String[] stringArray = new String[]{"\u0000"};
                String address = (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
                int port = buf.readUnsignedShort();
                int nextState = buf.m_130242_();
                this.pingData = new ClientPingProxyPacket(address, port, protocolVersion);
                if (nextState == 1) {
                    this.isQuery = true;
                } else {
                    Essential.logger.warn("Invalid nextState " + nextState + " sent to pingproxy");
                    this.getChannel().close();
                }
            }
        } else {
            switch (id2) {
                case 0: {
                    ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
                    ClientPingProxyPacket clientPingProxyPacket = this.pingData;
                    Intrinsics.checkNotNull((Object)clientPingProxyPacket);
                    connectionManager.send(clientPingProxyPacket, arg_0 -> ProxyPingPacketHandler.channelRead0$lambda$0(this, arg_0), TimeUnit.SECONDS, 7L);
                    break;
                }
                case 1: {
                    this.getChannel().close();
                }
            }
        }
    }

    private final void sendPacket(int id2, Function1<? super FriendlyByteBuf, Unit> writer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(id2);
        writer.invoke((Object)buf);
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130130_(buf.readableBytes());
        packet.writeBytes((ByteBuf)buf);
        this.getChannel().writeAndFlush((Object)packet);
    }

    private static final void channelRead0$lambda$0(ProxyPingPacketHandler this$0, Optional maybeResponse) {
        ServerPingProxyResponsePacket response2;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object var3_2 = maybeResponse.orElse(null);
        ServerPingProxyResponsePacket serverPingProxyResponsePacket = response2 = var3_2 instanceof ServerPingProxyResponsePacket ? (ServerPingProxyResponsePacket)var3_2 : null;
        if (response2 != null) {
            this$0.sendPacket(0, (Function1<? super FriendlyByteBuf, Unit>)((Function1)new Function1<FriendlyByteBuf, Unit>(response2){
                final /* synthetic */ ServerPingProxyResponsePacket $response;
                {
                    this.$response = $response;
                    super(1);
                }

                public final void invoke(@NotNull FriendlyByteBuf $this$sendPacket) {
                    Intrinsics.checkNotNullParameter((Object)$this$sendPacket, (String)"$this$sendPacket");
                    $this$sendPacket.m_130070_(this.$response.getRawJson());
                }
            }));
            this$0.serverData.f_105366_ = response2.getLatency();
            ServerDataExtKt.setPingRegion(ServerDataExtKt.getExt(this$0.serverData), response2.getRegion());
        } else {
            this$0.getChannel().close();
            ClientPingProxyPacket clientPingProxyPacket = this$0.pingData;
            ClientPingProxyPacket clientPingProxyPacket2 = this$0.pingData;
            ClientPingProxyPacket clientPingProxyPacket3 = this$0.pingData;
            Essential.logger.info("Received no response from ping proxy for " + (clientPingProxyPacket != null ? clientPingProxyPacket.getHostname() : null) + ":" + (clientPingProxyPacket2 != null ? Integer.valueOf(clientPingProxyPacket2.getPort()) : null) + " (" + (clientPingProxyPacket3 != null ? Integer.valueOf(clientPingProxyPacket3.getProtocolVersion()) : null) + ")");
        }
    }
}

