/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.subscription;

import com.google.common.collect.Sets;
import gg.essential.connectionmanager.common.packet.subscription.SubscriptionUpdatePacket;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.util.UUIDUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class SubscriptionManager
implements NetworkedManager {
    @NotNull
    private final PacketQueue packetQueue;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final Set<UUID> subscriptions = Sets.newConcurrentHashSet();

    public SubscriptionManager(@NotNull ConnectionManager connectionManager) {
        this.packetQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
    }

    public boolean isSubscribedOrSelf(@NotNull UUID uuid) {
        return this.isSubscribed(uuid) || uuid.equals(UUIDUtil.getClientUUID());
    }

    public boolean isSubscribed(@NotNull UUID uuid) {
        return this.subscriptions.contains(uuid);
    }

    public void subscribeToFeeds(@NotNull Set<UUID> uuids) {
        uuids.remove(UUIDUtil.getClientUUID());
        this.subscriptions.addAll(uuids);
        this.packetQueue.enqueue(new SubscriptionUpdatePacket(uuids.toArray(new UUID[0]), true), response2 -> {
            for (Listener listener2 : this.listeners) {
                listener2.onSubscriptionAdded(uuids);
            }
        });
    }

    public void unSubscribeFromFeeds(@NotNull Set<UUID> uuids) {
        uuids.remove(UUIDUtil.getClientUUID());
        this.subscriptions.removeAll(uuids);
        this.packetQueue.enqueue(new SubscriptionUpdatePacket(uuids.toArray(new UUID[0]), false), response2 -> {
            for (Listener listener2 : this.listeners) {
                listener2.onSubscriptionRemoved(uuids);
            }
        });
    }

    @Override
    public void onConnected() {
        this.packetQueue.reset();
        HashSet<UUID> uuids = new HashSet<UUID>(this.subscriptions);
        this.resetState();
        this.subscribeToFeeds(uuids);
    }

    @Override
    public void resetState() {
        HashSet<UUID> uuids = new HashSet<UUID>(this.subscriptions);
        this.subscriptions.clear();
        for (Listener listener2 : this.listeners) {
            listener2.onSubscriptionRemoved(uuids);
        }
    }

    public void addListener(@NotNull Listener listener2) {
        this.listeners.add(listener2);
    }

    public static interface Listener {
        default public void onSubscriptionAdded(@NotNull Set<UUID> uuids) {
        }

        default public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        }
    }
}

