/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.skins;

import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.connectionmanager.common.packet.skin.ClientSkinCreatePacket;
import gg.essential.connectionmanager.common.packet.skin.ClientSkinDeletePacket;
import gg.essential.connectionmanager.common.packet.skin.ClientSkinUpdateDataPacket;
import gg.essential.connectionmanager.common.packet.skin.ClientSkinUpdateFavoriteStatePacket;
import gg.essential.connectionmanager.common.packet.skin.ClientSkinUpdateLastUsedStatePacket;
import gg.essential.connectionmanager.common.packet.skin.ClientSkinUpdateNamePacket;
import gg.essential.connectionmanager.common.packet.skin.ServerSkinPopulatePacket;
import gg.essential.gui.common.modal.DangerConfirmationEssentialModal;
import gg.essential.gui.common.modal.EssentialModal;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.elementa.state.v2.ListKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.collections.TrackedList;
import gg.essential.gui.elementa.state.v2.combinators.StateKt;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.gui.wardrobe.Item;
import gg.essential.mod.Model;
import gg.essential.mod.Skin;
import gg.essential.mod.cosmetics.CosmeticOutfit;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.handler.skins.ServerSkinPopulatePacketHandler;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.skins.SkinsManager;
import gg.essential.network.cosmetics.ConversionsKt;
import gg.essential.util.GuiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J7\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00182\n\u0010\u0017\u001a\u00060\u0006j\u0002`\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001f\u001a\u00020\u00112\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0016\u0012\u0004\u0012\u00020\u000e0\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000e\u00a2\u0006\u0004\b!\u0010\u0013J\u001d\u0010\"\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b$\u0010\u001cJ\u0015\u0010\u000b\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u0013J\u001d\u0010%\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010)\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010+\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u000e\u00a2\u0006\u0004\b+\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010,\u001a\u0004\b-\u0010.R*\u00100\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0016\u0012\u0004\u0012\u00020\u000e0\u001d0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001c\u00104\u001a\n 3*\u0004\u0018\u000102028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R-\u0010\u001e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0016\u0012\u0004\u0012\u00020\u000e0\u001d0\u00188\u0006\u00a2\u0006\f\n\u0004\b\u001e\u00106\u001a\u0004\b7\u00108R-\u0010;\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e090\u0018j\b\u0012\u0004\u0012\u00020\u000e`:8\u0006\u00a2\u0006\f\n\u0004\b;\u00106\u001a\u0004\b<\u00108\u00a8\u0006="}, d2={"Lgg/essential/network/connectionmanager/skins/SkinsManager;", "Lgg/essential/network/connectionmanager/NetworkedManager;", "Lgg/essential/network/connectionmanager/ConnectionManager;", "connectionManager", "<init>", "(Lgg/essential/network/connectionmanager/ConnectionManager;)V", "", "name", "Lgg/essential/mod/Skin;", "skin", "", "selectSkin", "favorite", "Ljava/util/concurrent/CompletableFuture;", "Lgg/essential/gui/wardrobe/Item$SkinItem;", "addSkin", "(Ljava/lang/String;Lgg/essential/mod/Skin;ZZ)Ljava/util/concurrent/CompletableFuture;", "", "deleteSkin", "(Lgg/essential/gui/wardrobe/Item$SkinItem;)V", "getNextIncrementalSkinName", "()Ljava/lang/String;", "Lgg/essential/cosmetics/SkinId;", "id", "Lgg/essential/gui/elementa/state/v2/State;", "getSkin", "(Ljava/lang/String;)Lgg/essential/gui/elementa/state/v2/State;", "onConnected", "()V", "", "skins", "onSkinPopulate", "(Ljava/util/Map;)V", "openDeleteSkinModal", "renameSkin", "(Lgg/essential/gui/wardrobe/Item$SkinItem;Ljava/lang/String;)V", "resetState", "setFavoriteState", "(Lgg/essential/gui/wardrobe/Item$SkinItem;Z)V", "Lgg/essential/mod/Model;", "model", "setSkinModel", "(Lgg/essential/gui/wardrobe/Item$SkinItem;Lgg/essential/mod/Model;)V", "updateLastUsedAtState", "Lgg/essential/network/connectionmanager/ConnectionManager;", "getConnectionManager", "()Lgg/essential/network/connectionmanager/ConnectionManager;", "Lgg/essential/gui/elementa/state/v2/MutableState;", "mutableSkins", "Lgg/essential/gui/elementa/state/v2/MutableState;", "Lgg/essential/network/connectionmanager/queue/SequentialPacketQueue;", "kotlin.jvm.PlatformType", "packetQueue", "Lgg/essential/network/connectionmanager/queue/SequentialPacketQueue;", "Lgg/essential/gui/elementa/state/v2/State;", "getSkins", "()Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/elementa/state/v2/collections/TrackedList;", "Lgg/essential/gui/elementa/state/v2/ListState;", "skinsOrdered", "getSkinsOrdered", "Essential 1.18.2-forge"})
@SourceDebugExtension(value={"SMAP\nSkinsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinsManager.kt\ngg/essential/network/connectionmanager/skins/SkinsManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n125#2:176\n152#2,3:177\n1#3:180\n1747#4,3:181\n*S KotlinDebug\n*F\n+ 1 SkinsManager.kt\ngg/essential/network/connectionmanager/skins/SkinsManager\n*L\n74#1:176\n74#1:177,3\n104#1:181,3\n*E\n"})
public final class SkinsManager
implements NetworkedManager {
    @NotNull
    private final ConnectionManager connectionManager;
    private final SequentialPacketQueue packetQueue;
    @NotNull
    private final MutableState<Map<String, Item.SkinItem>> mutableSkins;
    @NotNull
    private final State<Map<String, Item.SkinItem>> skins;
    @NotNull
    private final State<TrackedList<Item.SkinItem>> skinsOrdered;

    public SkinsManager(@NotNull ConnectionManager connectionManager) {
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        this.connectionManager = connectionManager;
        this.packetQueue = new SequentialPacketQueue.Builder(this.connectionManager).onTimeoutSkip().create();
        this.mutableSkins = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(MapsKt.emptyMap());
        this.skins = this.mutableSkins;
        this.skinsOrdered = ListKt.toListState(StateKt.map((State)this.mutableSkins, skinsOrdered.1.INSTANCE));
        this.connectionManager.registerPacketHandler(ServerSkinPopulatePacket.class, new ServerSkinPopulatePacketHandler());
    }

    @NotNull
    public final ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @NotNull
    public final State<Map<String, Item.SkinItem>> getSkins() {
        return this.skins;
    }

    @NotNull
    public final State<TrackedList<Item.SkinItem>> getSkinsOrdered() {
        return this.skinsOrdered;
    }

    @Override
    public void onConnected() {
        this.resetState();
    }

    @Override
    public void resetState() {
        this.mutableSkins.set((Map<String, Item.SkinItem>)((Object)resetState.1.INSTANCE));
    }

    @NotNull
    public final State<Item.SkinItem> getSkin(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return StateKt.map(this.skins, (Function1)new Function1<Map<String, ? extends Item.SkinItem>, Item.SkinItem>(id2){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            @Nullable
            public final Item.SkinItem invoke(@NotNull Map<String, Item.SkinItem> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.get(this.$id);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getNextIncrementalSkinName() {
        String string;
        block4: {
            void $this$mapTo$iv$iv;
            Map<String, Item.SkinItem> $this$map$iv = this.skins.get();
            boolean $i$f$map = false;
            Map<String, Item.SkinItem> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Item.SkinItem)it.getValue()).getName());
            }
            Set skinNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterator iterator2 = ((Iterable)new IntRange(skinNames.size() + 1, Integer.MAX_VALUE)).iterator();
            while (iterator2.hasNext()) {
                String string2;
                int i2 = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                String it = string2 = "Skin #" + i2;
                boolean bl2 = false;
                String string3 = !skinNames.contains(it) ? string2 : null;
                string = string3;
                if (string3 == null) {
                    continue;
                }
                break block4;
            }
            string = null;
        }
        if (string == null) {
            throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
        }
        return string;
    }

    @NotNull
    public final CompletableFuture<Item.SkinItem> addSkin(@NotNull String name2, @NotNull Skin skin, boolean selectSkin, boolean favorite) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        CompletableFuture<Item.SkinItem> future2 = new CompletableFuture<Item.SkinItem>();
        this.connectionManager.send(new ClientSkinCreatePacket(name2, ConversionsKt.toInfra(skin.getModel()), skin.getHash(), favorite), arg_0 -> SkinsManager.addSkin$lambda$3(future2, selectSkin, this, arg_0));
        return future2;
    }

    public static /* synthetic */ CompletableFuture addSkin$default(SkinsManager skinsManager, String string, Skin skin, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return skinsManager.addSkin(string, skin, bl, bl2);
    }

    public final void openDeleteSkinModal(@NotNull Item.SkinItem skin) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
            Iterable $this$any$iv = this.connectionManager.getOutfitManager().getOutfits().get();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CosmeticOutfit it = (CosmeticOutfit)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getSkinId(), (Object)skin.getId())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            ExtensionsKt.error$default(Notifications.INSTANCE, "Can\u2019t delete skin", "Skin is currently used on one or more outfits.", null, null, null, 28, null);
            return;
        }
        GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)new Function1<ModalManager, Modal>(skin, this){
            final /* synthetic */ Item.SkinItem $skin;
            final /* synthetic */ SkinsManager this$0;
            {
                this.$skin = $skin;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Modal invoke(@NotNull ModalManager manager) {
                void $this$configure$iv;
                void var5_5;
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                EssentialModal essentialModal = new DangerConfirmationEssentialModal(manager, "Delete", false);
                Item.SkinItem skinItem = this.$skin;
                boolean $i$f$configure = false;
                void $this$configure_u24lambda_u240$iv = var5_5 = $this$configure$iv;
                boolean bl = false;
                DangerConfirmationEssentialModal $this$invoke_u24lambda_u240 = (DangerConfirmationEssentialModal)$this$configure_u24lambda_u240$iv;
                boolean bl2 = false;
                $this$invoke_u24lambda_u240.setContentText("Are you sure you want to delete\n" + skinItem.getName() + "?");
                return ((DangerConfirmationEssentialModal)var5_5).onPrimaryAction((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$skin){
                    final /* synthetic */ SkinsManager this$0;
                    final /* synthetic */ Item.SkinItem $skin;
                    {
                        this.this$0 = $receiver;
                        this.$skin = $skin;
                        super(0);
                    }

                    public final void invoke() {
                        SkinsManager.access$deleteSkin(this.this$0, this.$skin);
                    }
                }));
            }
        }));
    }

    private final void deleteSkin(Item.SkinItem skin) {
        this.connectionManager.send(new ClientSkinDeletePacket(skin.getId()), arg_0 -> SkinsManager.deleteSkin$lambda$5(this, skin, arg_0));
    }

    public final void setFavoriteState(@NotNull Item.SkinItem skin, boolean favorite) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        this.packetQueue.enqueue(new ClientSkinUpdateFavoriteStatePacket(skin.getId(), favorite), SkinsManager::setFavoriteState$lambda$6);
    }

    public final void renameSkin(@NotNull Item.SkinItem skin, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.packetQueue.enqueue(new ClientSkinUpdateNamePacket(skin.getId(), name2), SkinsManager::renameSkin$lambda$7);
    }

    public final void updateLastUsedAtState(@NotNull Item.SkinItem skin) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        this.packetQueue.enqueue(new ClientSkinUpdateLastUsedStatePacket(skin.getId()), SkinsManager::updateLastUsedAtState$lambda$8);
    }

    public final void setSkinModel(@NotNull Item.SkinItem skin, @NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.packetQueue.enqueue(new ClientSkinUpdateDataPacket(skin.getId(), ConversionsKt.toInfra(model), skin.getSkin().getHash()), SkinsManager::setSkinModel$lambda$9);
    }

    public final void selectSkin(@NotNull Item.SkinItem skin) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        this.connectionManager.getOutfitManager().updateOutfitSkin(skin.getId(), false);
    }

    public final void onSkinPopulate(@NotNull Map<String, Item.SkinItem> skins) {
        Intrinsics.checkNotNullParameter(skins, (String)"skins");
        this.mutableSkins.set((Map<String, Item.SkinItem>)((Function1)new Function1<Map<String, ? extends Item.SkinItem>, Map<String, ? extends Item.SkinItem>>(skins){
            final /* synthetic */ Map<String, Item.SkinItem> $skins;
            {
                this.$skins = $skins;
                super(1);
            }

            @NotNull
            public final Map<String, Item.SkinItem> invoke(@NotNull Map<String, Item.SkinItem> map2) {
                Intrinsics.checkNotNullParameter(map2, (String)"map");
                return MapsKt.plus(map2, this.$skins);
            }
        }));
    }

    private static final void addSkin$lambda$3(CompletableFuture $future, boolean $selectSkin, SkinsManager this$0, Optional maybeResponse) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Packet response2 = maybeResponse.orElse(null);
        if (response2 instanceof ServerSkinPopulatePacket) {
            List<gg.essential.skins.model.Skin> list = ((ServerSkinPopulatePacket)response2).getSkins();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSkins(...)");
            List<gg.essential.skins.model.Skin> skinResponse = list;
            if (skinResponse.isEmpty()) {
                $future.completeExceptionally(new IllegalStateException("Received empty reply when creating skin!"));
                return;
            }
            Object object = CollectionsKt.first(skinResponse);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            Item.SkinItem skinItem = ConversionsKt.toMod((gg.essential.skins.model.Skin)object);
            if ($selectSkin) {
                this$0.selectSkin(skinItem);
            }
            $future.complete(skinItem);
        } else {
            $future.completeExceptionally(new IllegalStateException("Failed to add skin!"));
        }
    }

    private static final void deleteSkin$lambda$5(SkinsManager this$0, Item.SkinItem $skin, Optional maybeResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$skin, (String)"$skin");
        Packet response2 = maybeResponse.orElse(null);
        if (response2 instanceof ResponseActionPacket && ((ResponseActionPacket)response2).isSuccessful()) {
            this$0.mutableSkins.set((Map<String, Item.SkinItem>)((Function1)new Function1<Map<String, ? extends Item.SkinItem>, Map<String, ? extends Item.SkinItem>>($skin){
                final /* synthetic */ Item.SkinItem $skin;
                {
                    this.$skin = $skin;
                    super(1);
                }

                @NotNull
                public final Map<String, Item.SkinItem> invoke(@NotNull Map<String, Item.SkinItem> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return MapsKt.minus(it, (Object)this.$skin.getId());
                }
            }));
        } else {
            Notifications.INSTANCE.push("Error deleting skin", "An unexpected error has occurred. Try again.");
        }
    }

    private static final void setFavoriteState$lambda$6(Optional maybeResponse) {
        Packet response2 = maybeResponse.orElse(null);
        if (!(response2 instanceof ServerSkinPopulatePacket)) {
            Notifications.INSTANCE.push("Error updating skin", "An unexpected error has occurred. Try again.");
        }
    }

    private static final void renameSkin$lambda$7(Optional maybeResponse) {
        Packet response2 = maybeResponse.orElse(null);
        if (!(response2 instanceof ServerSkinPopulatePacket)) {
            Notifications.INSTANCE.push("Error updating skin", "An unexpected error has occurred. Try again.");
        }
    }

    private static final void updateLastUsedAtState$lambda$8(Optional maybeResponse) {
        Packet response2 = maybeResponse.orElse(null);
        if (!(response2 instanceof ServerSkinPopulatePacket)) {
            Notifications.INSTANCE.push("Error updating skin", "An unexpected error has occurred. Try again.");
        }
    }

    private static final void setSkinModel$lambda$9(Optional maybeResponse) {
        Packet response2 = maybeResponse.orElse(null);
        if (!(response2 instanceof ServerSkinPopulatePacket)) {
            Notifications.INSTANCE.push("Error updating skin", "An unexpected error has occurred. Try again.");
        }
    }

    public static final /* synthetic */ void access$deleteSkin(SkinsManager $this, Item.SkinItem skin) {
        $this.deleteSkin(skin);
    }
}

