/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.queue;

import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.util.Multithreading;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequentialPacketQueue
implements PacketQueue {
    private static final long ATTEMPT_RESEND_SECONDS = 1L;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final TimeoutPolicy timeoutPolicy;
    @NotNull
    private final Queue<Pair<Packet, Consumer<Optional<Packet>>>> queue = new ArrayDeque<Pair<Packet, Consumer<Optional<Packet>>>>();
    @Nullable
    private Pair<Packet, Consumer<Optional<Packet>>> waitingFor;

    public SequentialPacketQueue(@NotNull ConnectionManager connectionManager, @NotNull TimeoutPolicy timeoutPolicy) {
        this.connectionManager = connectionManager;
        this.timeoutPolicy = timeoutPolicy;
    }

    @Override
    public synchronized void enqueue(Packet packet, Consumer<Optional<Packet>> responseCallback) {
        this.queue.add((Pair<Packet, Consumer<Optional<Packet>>>)new Pair((Object)packet, responseCallback));
        this.process();
    }

    private void process() {
        if (this.waitingFor != null) {
            return;
        }
        Pair<Packet, Consumer<Optional<Packet>>> next = this.queue.poll();
        if (next == null) {
            return;
        }
        this.waitingFor = next;
        this.attemptSend(next);
    }

    private synchronized void attemptSend(@NotNull Pair<Packet, Consumer<Optional<Packet>>> next) {
        if (this.connectionManager.isOpen() && this.connectionManager.isAuthenticated()) {
            this.connectionManager.send((Packet)next.getFirst(), resp -> this.handleResponse(next, (Optional<Packet>)resp));
        } else if (this.timeoutPolicy == TimeoutPolicy.RETRANSMIT) {
            Multithreading.getScheduledPool().schedule(() -> this.attemptSend(next), 1L, TimeUnit.SECONDS);
        } else {
            this.handleResponse(next, Optional.empty());
        }
    }

    private synchronized void handleResponse(@NotNull Pair<Packet, Consumer<Optional<Packet>>> request2, Optional<Packet> response2) {
        if (this.waitingFor != request2) {
            return;
        }
        if (response2.isPresent() || this.timeoutPolicy == TimeoutPolicy.SKIP) {
            this.waitingFor = null;
            Consumer responseCallback = (Consumer)request2.getSecond();
            if (responseCallback != null) {
                responseCallback.accept(response2);
            }
        } else {
            this.attemptSend(request2);
        }
        this.process();
    }

    @Override
    public synchronized void reset() {
        this.queue.clear();
        this.waitingFor = null;
    }

    public static enum TimeoutPolicy {
        RETRANSMIT,
        SKIP;

    }

    public static class Builder {
        @NotNull
        private final ConnectionManager connectionManager;
        @NotNull
        private TimeoutPolicy timeoutPolicy = TimeoutPolicy.RETRANSMIT;

        public Builder(@NotNull ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
        }

        public Builder onTimeoutRetransmit() {
            return this.setTimeoutPolicy(TimeoutPolicy.RETRANSMIT);
        }

        public Builder onTimeoutSkip() {
            return this.setTimeoutPolicy(TimeoutPolicy.SKIP);
        }

        public Builder setTimeoutPolicy(@NotNull TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy = timeoutPolicy;
            return this;
        }

        public SequentialPacketQueue create() {
            return new SequentialPacketQueue(this.connectionManager, this.timeoutPolicy);
        }
    }
}

