/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.notices;

import com.google.common.collect.Maps;
import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.notices.ClientNoticeDismissPacket;
import gg.essential.connectionmanager.common.packet.notices.ClientNoticeRequestPacket;
import gg.essential.connectionmanager.common.packet.notices.ServerNoticePopulatePacket;
import gg.essential.connectionmanager.common.packet.notices.ServerNoticeRemovePacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.state.Sale;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.notices.FriendRequestToastNoticeListener;
import gg.essential.network.connectionmanager.notices.GiftedCosmeticNoticeListener;
import gg.essential.network.connectionmanager.notices.NoticeBannerManager;
import gg.essential.network.connectionmanager.notices.PersistentToastNoticeListener;
import gg.essential.network.connectionmanager.notices.SocialMenuNewFriendRequestNoticeManager;
import gg.essential.network.connectionmanager.notices.handler.ServerNoticePopulatePacketHandler;
import gg.essential.network.connectionmanager.notices.handler.ServerNoticeRemovePacketHandler;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.notices.NoticeType;
import gg.essential.notices.model.Notice;
import gg.essential.util.Multithreading;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoticesManager
implements NetworkedManager {
    @NotNull
    private final Map<String, Notice> notices = Maps.newConcurrentMap();
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final CosmeticNotices cosmeticNotices = new CosmeticNotices();
    @NotNull
    private final SaleNoticeManager saleNoticeManager = new SaleNoticeManager();
    @NotNull
    private final SocialMenuNewFriendRequestNoticeManager socialMenuNewFriendRequestNoticeManager;
    private NoticeBannerManager noticeBannerManager;
    private final List<NoticeListener> listeners = new ArrayList<NoticeListener>(Arrays.asList(this.cosmeticNotices, this.saleNoticeManager));

    public NoticesManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(ServerNoticePopulatePacket.class, new ServerNoticePopulatePacketHandler(this));
        connectionManager.registerPacketHandler(ServerNoticeRemovePacket.class, new ServerNoticeRemovePacketHandler(this));
        this.listeners.add(new FriendRequestToastNoticeListener(connectionManager, this));
        this.listeners.add(new PersistentToastNoticeListener(this));
        this.noticeBannerManager = new NoticeBannerManager(this);
        this.listeners.add(this.noticeBannerManager);
        this.socialMenuNewFriendRequestNoticeManager = new SocialMenuNewFriendRequestNoticeManager(this);
        this.listeners.add(this.socialMenuNewFriendRequestNoticeManager);
        this.listeners.add(new GiftedCosmeticNoticeListener(this));
    }

    @NotNull
    public Map<String, Notice> getNotices() {
        return this.notices;
    }

    @NotNull
    public Optional<Notice> getNotice(@NotNull String notice) {
        return Optional.ofNullable(this.notices.get(notice));
    }

    @NotNull
    public List<Notice> getNotices(@NotNull NoticeType noticeType, @Nullable Set<String> metadataKeys, @Nullable Map<String, Object> metadataValues) {
        return this.notices.values().stream().filter(notice -> notice.getType() == noticeType).filter(notice -> {
            if (metadataKeys == null || metadataKeys.isEmpty()) {
                return true;
            }
            Map<String, Object> metadata2 = notice.getMetadata();
            if (metadata2.isEmpty()) {
                return false;
            }
            for (String metadataKey : metadataKeys) {
                if (metadata2.containsKey(metadataKey)) continue;
                return false;
            }
            return true;
        }).filter(notice -> {
            if (metadataValues == null || metadataValues.isEmpty()) {
                return true;
            }
            Map<String, Object> metadata2 = notice.getMetadata();
            if (metadata2.isEmpty()) {
                return false;
            }
            Iterator iterator = metadataValues.entrySet().iterator();
            if (iterator.hasNext()) {
                @NotNull Map.Entry<K, V> entry = iterator.next();
                Object metadataValue = metadata2.get(entry.getKey());
                if (metadataValue == null) {
                    return false;
                }
                return Objects.equals(metadataValue, entry.getValue());
            }
            return false;
        }).collect(Collectors.toList());
    }

    public void populateNotices(@NotNull Collection<Notice> notices) {
        for (Notice notice : notices) {
            this.notices.put(notice.getId(), notice);
            for (NoticeListener listener2 : this.listeners) {
                listener2.noticeAdded(notice);
            }
        }
    }

    public void removeNotices(@Nullable Set<String> noticeIds) {
        if (noticeIds == null || noticeIds.isEmpty()) {
            for (Notice value2 : this.notices.values()) {
                for (NoticeListener listener2 : this.listeners) {
                    listener2.noticeRemoved(value2);
                }
            }
            this.notices.clear();
            return;
        }
        for (String noticeId : noticeIds) {
            Notice removed = this.notices.remove(noticeId);
            if (removed == null) continue;
            for (NoticeListener listener3 : this.listeners) {
                listener3.noticeRemoved(removed);
            }
        }
    }

    public void dismissNotice(String noticeId) {
        this.connectionManager.send(new ClientNoticeDismissPacket(noticeId), packet -> {
            Packet packet1;
            if (packet.isPresent() && (packet1 = (Packet)packet.get()) instanceof ResponseActionPacket && ((ResponseActionPacket)packet1).isSuccessful()) {
                this.notices.remove(noticeId);
                return;
            }
            Essential.logger.error("Unexpected notice response: " + packet);
        });
    }

    public SocialMenuNewFriendRequestNoticeManager getSocialMenuNewFriendRequestNoticeManager() {
        return this.socialMenuNewFriendRequestNoticeManager;
    }

    @NotNull
    public NoticeBannerManager getNoticeBannerManager() {
        return this.noticeBannerManager;
    }

    @Override
    public void resetState() {
        this.notices.clear();
        this.listeners.forEach(NoticeListener::resetState);
    }

    @Override
    public void onConnected() {
        this.resetState();
        this.connectionManager.send(new ClientNoticeRequestPacket(null, SetsKt.setOf((Object[])NoticeType.values()), null, null));
        this.listeners.forEach(NoticeListener::onConnect);
    }

    @NotNull
    public CosmeticNotices getCosmeticNotices() {
        return this.cosmeticNotices;
    }

    @NotNull
    public SaleNoticeManager getSaleNoticeManager() {
        return this.saleNoticeManager;
    }

    public class CosmeticNotices
    implements NoticeListener {
        private final String METADATA_KEY = "cosmetic_id";
        private final ConcurrentHashMap<String, MutableState<Boolean>> cosmeticToNewStateMap = new ConcurrentHashMap();
        private final MutableState<Boolean> hasAnyNewCosmetics = StateKt.mutableStateOf(false);

        public State<Boolean> getNewState(String cosmeticId) {
            return this.cosmeticToNewStateMap.computeIfAbsent(cosmeticId, ignored -> StateKt.mutableStateOf(false));
        }

        private void updateGlobalState() {
            this.hasAnyNewCosmetics.set(this.cosmeticToNewStateMap.entrySet().stream().anyMatch(entry -> {
                if (!((Boolean)((MutableState)entry.getValue()).get()).booleanValue()) {
                    return false;
                }
                Cosmetic cosmetic2 = NoticesManager.this.connectionManager.getCosmeticsManager().getCosmetic((String)entry.getKey());
                if (cosmetic2 == null) {
                    return false;
                }
                return cosmetic2.isAvailable();
            }));
        }

        public State<Boolean> getHasAnyNewCosmetics() {
            return this.hasAnyNewCosmetics;
        }

        @Override
        public void noticeAdded(Notice notice) {
            if (notice.getType() == NoticeType.NEW_BANNER && notice.getMetadata().containsKey("cosmetic_id")) {
                String cosmeticId = (String)notice.getMetadata().get("cosmetic_id");
                this.cosmeticToNewStateMap.computeIfAbsent(cosmeticId, ignored -> StateKt.mutableStateOf(true)).set(true);
                this.updateGlobalState();
            }
        }

        @Override
        public void noticeRemoved(Notice notice) {
        }

        @Override
        public void onConnect() {
            this.resetState();
        }

        public void cosmeticAdded(String id2) {
            MutableState<Boolean> existingState = this.cosmeticToNewStateMap.get(id2);
            if (existingState != null && ((Boolean)existingState.get()).booleanValue()) {
                this.updateGlobalState();
            }
        }
    }

    public class SaleNoticeManager
    implements NoticeListener {
        private final boolean saleSuppressedByJvmFlag = System.getProperty("essential.disableSale", "false").equals("true");
        private final MutableState<@NotNull Set<Sale>> currentState = StateKt.mutableStateOf(Collections.emptySet());
        private final Map<String, Sale> salesMap = new HashMap<String, Sale>();
        private ScheduledFuture<?> nextUpdateFuture = null;

        @Override
        public void noticeAdded(Notice notice) {
            if (this.saleSuppressedByJvmFlag) {
                return;
            }
            if (notice.getType() == NoticeType.SALE) {
                if (notice.getExpiresAt() == null) {
                    Essential.logger.error("Notice " + notice.getId() + " is type sale but does not have an expiration date set!");
                    return;
                }
                int discount = ((Number)notice.getMetadata().get("discount")).intValue();
                @Nullable HashSet<Integer> packagesSet = null;
                if (notice.getMetadata().containsKey("packages")) {
                    packagesSet = new HashSet<Integer>();
                    for (Number packages : (Collection)notice.getMetadata().get("packages")) {
                        packagesSet.add(packages.intValue());
                    }
                    if (packagesSet.isEmpty()) {
                        packagesSet = null;
                    }
                }
                HashSet<String> onlyCosmetics = null;
                if (notice.getMetadata().containsKey("cosmetics")) {
                    onlyCosmetics = new HashSet<String>((Collection)notice.getMetadata().get("cosmetics"));
                }
                this.salesMap.put(notice.getId(), new Sale(notice.getExpiresAt().toInstant(), (String)notice.getMetadata().get("sale_name"), notice.getMetadata().containsKey("sale_name_compact") ? (String)notice.getMetadata().get("sale_name_compact") : (discount == 0 ? null : "SALE"), discount, (Boolean)notice.getMetadata().getOrDefault("display_time", Boolean.TRUE), (String)notice.getMetadata().get("category"), packagesSet, onlyCosmetics, (String)notice.getMetadata().get("tooltip"), (String)notice.getMetadata().get("coupon")));
                this.refreshState();
            }
        }

        private void refreshState() {
            this.currentState.set(new HashSet<Sale>(this.salesMap.values()));
            this.scheduleUpdate();
        }

        private void scheduleUpdate() {
            Optional<Sale> first;
            if (this.nextUpdateFuture != null) {
                this.nextUpdateFuture.cancel(false);
            }
            if ((first = this.salesMap.values().stream().min(Comparator.comparing(Sale::getExpiration))).isPresent()) {
                Sale sale = first.get();
                this.nextUpdateFuture = Multithreading.scheduleOnMainThread(() -> {
                    Instant now = Instant.now();
                    if (this.salesMap.entrySet().removeIf(entry -> ((Sale)entry.getValue()).getExpiration().isBefore(now))) {
                        this.refreshState();
                    }
                }, Instant.now().until(sale.getExpiration(), ChronoUnit.MILLIS) + 1000L, TimeUnit.MILLISECONDS);
            }
        }

        public State<@NotNull Set<Sale>> getSaleState() {
            return this.currentState;
        }

        @Override
        public void noticeRemoved(Notice notice) {
            if (notice.getType() == NoticeType.SALE) {
                this.salesMap.remove(notice.getId());
                this.refreshState();
            }
        }

        @Override
        public void onConnect() {
        }
    }

    static interface NoticeListener {
        public void noticeAdded(Notice var1);

        public void noticeRemoved(Notice var1);

        public void onConnect();

        default public void resetState() {
        }
    }
}

