/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice.netty;

import gg.essential.quic.LogOnce;
import gg.essential.sps.quic.QuicStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.local.LocalChannel;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuicStreamChannelInitializer
extends ChannelInitializer<LocalChannel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ByteBuf CLOSE_MARKER = Unpooled.buffer((int)0, (int)0);
    private final LogOnce debugOnce;
    private final QuicStream quicStream;
    private final UUID user;

    public QuicStreamChannelInitializer(QuicStream quicStream, UUID user) {
        this.quicStream = quicStream;
        this.user = user;
        this.debugOnce = LogOnce.to(s -> LOGGER.debug("[{}] {}", (Object)user, s));
    }

    protected void initChannel(LocalChannel channel2) {
        this.debugOnce.log("initChannel", channel2);
        final LinkedBlockingDeque outbound = new LinkedBlockingDeque();
        final Thread writer = new Thread(() -> this.lambda$initChannel$1(outbound, channel2));
        writer.setName("netty->quic (" + this.user + ")");
        writer.setDaemon(true);
        final Thread reader2 = new Thread(() -> {
            block8: {
                try {
                    InputStream inputStream = this.quicStream.getInputStream();
                    while (channel2.isOpen()) {
                        ByteBuf buf = channel2.alloc().buffer();
                        try {
                            if (buf.writeBytes(inputStream, buf.writableBytes()) <= 0) {
                                LOGGER.info("Closing.");
                                channel2.close();
                                return;
                            }
                            this.debugOnce.log("reader", buf);
                            channel2.writeAndFlush((Object)buf.retain());
                        }
                        finally {
                            buf.release();
                        }
                    }
                }
                catch (IOException e) {
                    this.debugOnce.log("readerException", e);
                    if (!channel2.isOpen()) break block8;
                    e.printStackTrace();
                }
            }
        });
        reader2.setName("netty<-quic (" + this.user + ")");
        reader2.setDaemon(true);
        channel2.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                QuicStreamChannelInitializer.this.debugOnce.log("channelActive", ctx);
                super.channelActive(ctx);
                reader2.start();
                writer.start();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                QuicStreamChannelInitializer.this.debugOnce.log("channelRead", msg);
                if (msg instanceof ByteBuf) {
                    outbound.add((ByteBuf)msg);
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                LOGGER.info("{} channel inactive, closing.", (Object)QuicStreamChannelInitializer.this.user);
                outbound.add(CLOSE_MARKER);
                reader2.interrupt();
                writer.join(10000L);
                reader2.join(10000L);
                LOGGER.info("{} closing QUIC.", (Object)QuicStreamChannelInitializer.this.user);
                QuicStreamChannelInitializer.this.quicStream.close();
                LOGGER.info("{} closed.", (Object)QuicStreamChannelInitializer.this.user);
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$initChannel$1(LinkedBlockingDeque outbound, LocalChannel channel) {
        try {
            outputStream = this.quicStream.getOutputStream();
            while (true) lbl-1000:
            // 3 sources

            {
                buf = (ByteBuf)outbound.take();
                this.debugOnce.log("writer", buf);
                if (buf == QuicStreamChannelInitializer.CLOSE_MARKER) {
                    QuicStreamChannelInitializer.LOGGER.info("Closing.");
                    outputStream.close();
                    return;
                }
                try {
                    buf.readBytes(outputStream, buf.readableBytes());
                }
                finally {
                    buf.release();
                    continue;
                }
                break;
            }
        }
        catch (IOException | InterruptedException e) {
            this.debugOnce.log("writerException", e);
            if (channel.isOpen()) {
                e.printStackTrace();
            }
            return;
        }
        ** GOTO lbl-1000
    }
}

