/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import com.google.common.collect.ImmutableMap;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticPlayerSettingsPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserEquippedPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ClientCosmeticOutfitSelectedRequestPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ServerCosmeticOutfitSelectedResponsePacket;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.cosmetics.ConnectionManagerKt;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsData;
import gg.essential.network.connectionmanager.cosmetics.InfraCosmeticsData;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticOutfitSelectedResponsePacketHandler;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.network.cosmetics.ConversionsKt;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.network.cosmetics.cape.CapeCosmeticsManager;
import gg.essential.util.UUIDUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001c\u0010\u0013J\u001d\u0010 \u001a\u00020\u001f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J\u001d\u0010\"\u001a\u00020\u001f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001dH\u0016\u00a2\u0006\u0004\b\"\u0010!J\u000f\u0010#\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0019\u00a2\u0006\u0004\b&\u0010'JC\u0010,\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0\u0014\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b.\u0010/R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00100R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00101R2\u00103\u001a \u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0\u0014028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00105R,\u0010(\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u0014028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u00104R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u00106R\u0016\u00107\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u0010:\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R,\u0010?\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u00104\u00a8\u0006A"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/EquippedCosmeticsManager;", "Lgg/essential/network/connectionmanager/NetworkedManager;", "Lgg/essential/network/connectionmanager/subscription/SubscriptionManager$Listener;", "Lgg/essential/network/connectionmanager/ConnectionManager;", "connectionManager", "Lgg/essential/network/cosmetics/cape/CapeCosmeticsManager;", "capeManager", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;", "cosmeticsData", "Lgg/essential/network/connectionmanager/cosmetics/InfraCosmeticsData;", "infraCosmeticsData", "<init>", "(Lgg/essential/network/connectionmanager/ConnectionManager;Lgg/essential/network/cosmetics/cape/CapeCosmeticsManager;Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;Lgg/essential/network/connectionmanager/cosmetics/InfraCosmeticsData;)V", "Ljava/util/UUID;", "playerId", "Lcom/google/common/collect/ImmutableMap;", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "Lgg/essential/cosmetics/EquippedCosmetic;", "computeVisibleCosmetics", "(Ljava/util/UUID;)Lcom/google/common/collect/ImmutableMap;", "", "", "getEquippedCosmetics", "()Ljava/util/Map;", "(Ljava/util/UUID;)Ljava/util/Map;", "", "getOwnCosmeticsVisible", "()Z", "getVisibleCosmetics", "", "uuids", "", "onSubscriptionAdded", "(Ljava/util/Set;)V", "onSubscriptionRemoved", "resetState", "()V", "state", "setOwnCosmeticsVisible", "(Z)V", "equippedCosmetics", "", "Lgg/essential/mod/cosmetics/settings/CosmeticSetting;", "settings", "update", "(Ljava/util/UUID;Ljava/util/Map;Ljava/util/Map;)V", "updateVisibleCosmetics", "(Ljava/util/UUID;)V", "Lgg/essential/network/cosmetics/cape/CapeCosmeticsManager;", "Lgg/essential/network/connectionmanager/ConnectionManager;", "", "cosmeticSettings", "Ljava/util/Map;", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;", "Lgg/essential/network/connectionmanager/cosmetics/InfraCosmeticsData;", "ownCosmeticsVisible", "Z", "Lgg/essential/elementa/state/v2/ReferenceHolder;", "refHolder", "Lgg/essential/elementa/state/v2/ReferenceHolder;", "Lgg/essential/network/connectionmanager/subscription/SubscriptionManager;", "subscriptionManager", "Lgg/essential/network/connectionmanager/subscription/SubscriptionManager;", "visibleCosmetics", "Companion", "Essential 1.18.2-forge"})
@SourceDebugExtension(value={"SMAP\nEquippedCosmeticsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EquippedCosmeticsManager.kt\ngg/essential/network/connectionmanager/cosmetics/EquippedCosmeticsManager\n+ 2 connectionManager.kt\ngg/essential/network/connectionmanager/cosmetics/ConnectionManagerKt\n*L\n1#1,219:1\n42#2:220\n42#2:221\n*S KotlinDebug\n*F\n+ 1 EquippedCosmeticsManager.kt\ngg/essential/network/connectionmanager/cosmetics/EquippedCosmeticsManager\n*L\n76#1:220\n81#1:221\n*E\n"})
public final class EquippedCosmeticsManager
implements NetworkedManager,
SubscriptionManager.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final CapeCosmeticsManager capeManager;
    @NotNull
    private final CosmeticsData cosmeticsData;
    @NotNull
    private final InfraCosmeticsData infraCosmeticsData;
    @NotNull
    private final ReferenceHolder refHolder;
    @NotNull
    private final SubscriptionManager subscriptionManager;
    @NotNull
    private final Map<UUID, Map<gg.essential.mod.cosmetics.CosmeticSlot, String>> equippedCosmetics;
    @NotNull
    private final Map<UUID, ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>> visibleCosmetics;
    @NotNull
    private final Map<UUID, Map<String, List<gg.essential.mod.cosmetics.settings.CosmeticSetting>>> cosmeticSettings;
    private boolean ownCosmeticsVisible;

    public EquippedCosmeticsManager(@NotNull ConnectionManager connectionManager, @NotNull CapeCosmeticsManager capeManager, @NotNull CosmeticsData cosmeticsData, @NotNull InfraCosmeticsData infraCosmeticsData) {
        ConnectionManager $this$registerPacketHandler$iv;
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)capeManager, (String)"capeManager");
        Intrinsics.checkNotNullParameter((Object)cosmeticsData, (String)"cosmeticsData");
        Intrinsics.checkNotNullParameter((Object)infraCosmeticsData, (String)"infraCosmeticsData");
        this.connectionManager = connectionManager;
        this.capeManager = capeManager;
        this.cosmeticsData = cosmeticsData;
        this.infraCosmeticsData = infraCosmeticsData;
        this.refHolder = new ReferenceHolderImpl();
        SubscriptionManager subscriptionManager = this.connectionManager.getSubscriptionManager();
        Intrinsics.checkNotNullExpressionValue((Object)subscriptionManager, (String)"getSubscriptionManager(...)");
        this.subscriptionManager = subscriptionManager;
        this.equippedCosmetics = new LinkedHashMap();
        this.visibleCosmetics = new LinkedHashMap();
        this.cosmeticSettings = new LinkedHashMap();
        this.ownCosmeticsVisible = true;
        this.subscriptionManager.addListener(this);
        ConnectionManagerKt.onNewCosmetic(this.cosmeticsData, this.refHolder, arg_0 -> EquippedCosmeticsManager._init_$lambda$0(this, arg_0));
        EssentialConfig.INSTANCE.getDisableCosmeticsState().onSetValue(this.refHolder, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean cosmeticsDisabled) {
                for (UUID playerId : equippedCosmetics.keySet()) {
                    this.updateVisibleCosmetics(playerId);
                }
                if (cosmeticsDisabled) {
                    return;
                }
                Map map2 = (Map)equippedCosmetics.get(UUIDUtil.getClientUUID());
                String capeHash = map2 != null ? (String)map2.get(gg.essential.mod.cosmetics.CosmeticSlot.CAPE) : null;
                Companion.setModelPartEnabled(PlayerModelPart.CAPE, !Intrinsics.areEqual((Object)"CAPE_DISABLED", (Object)capeHash));
            }
        }));
        ConnectionManager connectionManager2 = this.connectionManager;
        PacketHandler handler$iv = new PacketHandler<ServerCosmeticsUserEquippedPacket>(){

            @Override
            protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerCosmeticsUserEquippedPacket packet) {
                Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                UUID uUID = packet.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                Map<CosmeticSlot, String> map2 = packet.getEquipped();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getEquipped(...)");
                Map<gg.essential.mod.cosmetics.CosmeticSlot, String> map3 = ConversionsKt.slotsToMod(map2);
                Map map4 = (Map)cosmeticSettings.get(packet.getUUID());
                if (map4 == null) {
                    map4 = MapsKt.emptyMap();
                }
                this.update(uUID, map3, map4);
            }
        };
        boolean $i$f$registerPacketHandler = false;
        $this$registerPacketHandler$iv.registerPacketHandler(ServerCosmeticsUserEquippedPacket.class, handler$iv);
        $this$registerPacketHandler$iv = this.connectionManager;
        handler$iv = new PacketHandler<ServerCosmeticPlayerSettingsPacket>(){

            @Override
            protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerCosmeticPlayerSettingsPacket packet) {
                Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                UUID uUID = packet.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                Map map2 = (Map)equippedCosmetics.get(packet.getUUID());
                if (map2 == null) {
                    map2 = MapsKt.emptyMap();
                }
                Map<String, List<CosmeticSetting>> map3 = packet.getSettings();
                Intrinsics.checkNotNullExpressionValue(map3, (String)"getSettings(...)");
                this.update(uUID, map2, ConversionsKt.settingsToModSetting(map3));
            }
        };
        $i$f$registerPacketHandler = false;
        $this$registerPacketHandler$iv.registerPacketHandler(ServerCosmeticPlayerSettingsPacket.class, handler$iv);
        this.connectionManager.registerPacketHandler(ServerCosmeticOutfitSelectedResponsePacket.class, new ServerCosmeticOutfitSelectedResponsePacketHandler());
    }

    public final boolean getOwnCosmeticsVisible() {
        return this.ownCosmeticsVisible;
    }

    public final void setOwnCosmeticsVisible(boolean state2) {
        this.ownCosmeticsVisible = state2;
        UUID uUID = UUIDUtil.getClientUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getClientUUID(...)");
        this.updateVisibleCosmetics(uUID);
        if (EssentialConfig.INSTANCE.getOwnCosmeticsHidden() == state2) {
            EssentialConfig.INSTANCE.setOwnCosmeticsHidden(!state2);
        }
    }

    @NotNull
    public final Map<gg.essential.mod.cosmetics.CosmeticSlot, String> getEquippedCosmetics() {
        UUID uUID = UUIDUtil.getClientUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getClientUUID(...)");
        Map map2 = this.getEquippedCosmetics(uUID);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Nullable
    public final Map<gg.essential.mod.cosmetics.CosmeticSlot, String> getEquippedCosmetics(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.equippedCosmetics.get(playerId);
    }

    public final void update(@NotNull UUID playerId, @NotNull Map<gg.essential.mod.cosmetics.CosmeticSlot, String> equippedCosmetics, @NotNull Map<String, ? extends List<? extends gg.essential.mod.cosmetics.settings.CosmeticSetting>> settings2) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter(equippedCosmetics, (String)"equippedCosmetics");
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        if (this.subscriptionManager.isSubscribedOrSelf(playerId)) {
            this.infraCosmeticsData.requestCosmeticsIfMissing(equippedCosmetics.values());
            this.equippedCosmetics.put(playerId, equippedCosmetics);
            this.cosmeticSettings.put(playerId, settings2);
            this.updateVisibleCosmetics(playerId);
            if (Intrinsics.areEqual((Object)playerId, (Object)UUIDUtil.getClientUUID())) {
                String capeHash = equippedCosmetics.get(gg.essential.mod.cosmetics.CosmeticSlot.CAPE);
                boolean capeDisabled = Intrinsics.areEqual((Object)"CAPE_DISABLED", (Object)capeHash);
                if (!EssentialConfig.INSTANCE.getDisableCosmetics()) {
                    EquippedCosmeticsManager.Companion.setModelPartEnabled(PlayerModelPart.CAPE, !capeDisabled);
                }
                if (!capeDisabled && capeHash != null) {
                    this.capeManager.queueCape(capeHash);
                }
            }
        }
    }

    private final void updateVisibleCosmetics(UUID playerId) {
        ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic> newValue = this.computeVisibleCosmetics(playerId);
        if (!Intrinsics.areEqual(this.visibleCosmetics.get(playerId), newValue)) {
            this.visibleCosmetics.put(playerId, newValue);
        }
    }

    private final ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic> computeVisibleCosmetics(UUID playerId) {
        Map<gg.essential.mod.cosmetics.CosmeticSlot, String> map2 = this.equippedCosmetics.get(playerId);
        if (map2 == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
            return immutableMap;
        }
        Map<gg.essential.mod.cosmetics.CosmeticSlot, String> cosmeticIds = map2;
        Map map3 = this.cosmeticSettings.get(playerId);
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        Map settings2 = map3;
        boolean cosmeticsHidden = !this.ownCosmeticsVisible && Intrinsics.areEqual((Object)playerId, (Object)UUIDUtil.getClientUUID());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<gg.essential.mod.cosmetics.CosmeticSlot, String> entry : cosmeticIds.entrySet()) {
            Cosmetic cosmetic2;
            gg.essential.mod.cosmetics.CosmeticSlot slot = entry.getKey();
            String value2 = entry.getValue();
            if (!EquippedCosmeticsManager.computeVisibleCosmetics$isVisible(cosmeticsHidden, slot) || this.cosmeticsData.getCosmetic(value2) == null) continue;
            List list = (List)settings2.get(value2);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            builder.put((Object)slot, (Object)new EquippedCosmetic(cosmetic2, list));
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
        return immutableMap;
    }

    @NotNull
    public final ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic> getVisibleCosmetics(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        ImmutableMap immutableMap = this.visibleCosmetics.get(playerId);
        if (immutableMap == null) {
            ImmutableMap immutableMap2 = ImmutableMap.of();
            immutableMap = immutableMap2;
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap2, (String)"of(...)");
        }
        return immutableMap;
    }

    @Override
    public void resetState() {
        this.equippedCosmetics.clear();
        this.visibleCosmetics.clear();
        this.cosmeticSettings.clear();
    }

    @Override
    public void onSubscriptionAdded(@NotNull Set<UUID> uuids) {
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        for (UUID uuid : uuids) {
            this.connectionManager.send(new ClientCosmeticOutfitSelectedRequestPacket(uuid));
        }
    }

    @Override
    public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        for (UUID uuid : uuids) {
            this.equippedCosmetics.remove(uuid);
            this.visibleCosmetics.remove(uuid);
            this.cosmeticSettings.remove(uuid);
        }
    }

    private static final void _init_$lambda$0(EquippedCosmeticsManager this$0, Cosmetic cosmetic2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        for (Map.Entry<UUID, Map<gg.essential.mod.cosmetics.CosmeticSlot, String>> entry : this$0.equippedCosmetics.entrySet()) {
            UUID key = entry.getKey();
            Map<gg.essential.mod.cosmetics.CosmeticSlot, String> value2 = entry.getValue();
            if (!Intrinsics.areEqual((Object)cosmetic2.getId(), (Object)value2.get(cosmetic2.getType().getSlot()))) continue;
            this$0.updateVisibleCosmetics(key);
        }
    }

    private static final boolean computeVisibleCosmetics$isVisible(boolean cosmeticsHidden, gg.essential.mod.cosmetics.CosmeticSlot slot) {
        if (Intrinsics.areEqual((Object)slot, (Object)gg.essential.mod.cosmetics.CosmeticSlot.ICON)) {
            return true;
        }
        if (cosmeticsHidden && !Intrinsics.areEqual((Object)slot, (Object)gg.essential.mod.cosmetics.CosmeticSlot.EMOTE)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)slot, (Object)gg.essential.mod.cosmetics.CosmeticSlot.EMOTE) || !EssentialConfig.INSTANCE.getDisableEmotes();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/EquippedCosmeticsManager$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/entity/player/PlayerModelPart;", "part", "", "enabled", "", "setModelPartEnabled", "(Lnet/minecraft/world/entity/player/PlayerModelPart;Z)V", "Essential 1.18.2-forge"})
    public static final class Companion {
        private Companion() {
        }

        private final void setModelPartEnabled(PlayerModelPart part, boolean enabled) {
            Options gameSettings = Minecraft.m_91087_().f_91066_;
            if (gameSettings.m_168416_(part) != enabled) {
                gameSettings.m_168418_(part, enabled);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

