/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager;

import com.google.common.collect.Maps;
import com.sparkuniverse.toolbox.relationships.enums.FriendRequestPrivacySetting;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipState;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipType;
import com.sparkuniverse.toolbox.relationships.serialisation.FriendRequestPrivacySettingTypeAdapter;
import com.sparkuniverse.toolbox.relationships.serialisation.RelationshipStateAdapter;
import com.sparkuniverse.toolbox.relationships.serialisation.RelationshipTypeAdapter;
import com.sparkuniverse.toolbox.serialization.DateTimeTypeAdapter;
import com.sparkuniverse.toolbox.serialization.UUIDTypeAdapter;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.connection.ConnectionRegisterPacketTypeIdPacket;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.gson.JsonParseException;
import gg.essential.network.connectionmanager.UnknownPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionCodec {
    private static final String PACKET_PACKAGE = "gg.essential.connectionmanager.common.packet.";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final boolean LOG_PACKETS = System.getProperty("essential.logPackets", "false").equals("true");
    @NotNull
    private final AtomicInteger packetTypeId = new AtomicInteger();
    @NotNull
    private final Map<Integer, String> incomingPacketTypeIds = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, Integer> outgoingPacketTypeIds = Maps.newConcurrentMap();
    @NotNull
    public static final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).registerTypeAdapter((Type)((Object)RelationshipType.class), new RelationshipTypeAdapter()).registerTypeAdapter((Type)((Object)RelationshipState.class), new RelationshipStateAdapter()).registerTypeAdapter((Type)((Object)FriendRequestPrivacySetting.class), new FriendRequestPrivacySettingTypeAdapter()).registerTypeAdapter((Type)((Object)DateTime.class), new DateTimeTypeAdapter()).create();

    public ConnectionCodec() {
        String packetName = this.splitPacketPackage(ConnectionRegisterPacketTypeIdPacket.class);
        this.incomingPacketTypeIds.put(0, packetName);
        this.outgoingPacketTypeIds.put(packetName, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Packet decode(byte[] array) {
        Packet packet;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(array);
             DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
            Class<Object> packetClass;
            int packetTypeId = dataInputStream.readInt();
            String packetName = this.incomingPacketTypeIds.get(packetTypeId);
            if (packetName == null) {
                Essential.logger.warn("Unknown packet type id {} from connection manager.", (Object)packetTypeId);
                Packet packet2 = null;
                return packet2;
            }
            try {
                packetClass = Class.forName(PACKET_PACKAGE + packetName);
            }
            catch (ClassNotFoundException e) {
                packetClass = UnknownPacket.class;
            }
            String packetIdString = this.readString(dataInputStream);
            UUID packetId = null;
            if (!StringUtils.isEmpty((CharSequence)packetIdString)) {
                packetId = UUID.fromString(packetIdString);
            }
            String jsonString = this.readString(dataInputStream);
            if (LOG_PACKETS) {
                Essential.debug.info(packetId + " - " + packetClass.getSimpleName() + " " + jsonString);
            }
            try {
                packet = (Packet)gson.fromJson(jsonString, packetClass);
            }
            catch (JsonParseException e) {
                Essential.logger.error("Error when deserialising json '{}' for '{}'.", (Object)jsonString, packetClass, (Object)e);
                Packet packet3 = null;
                dataInputStream.close();
                byteArrayInputStream.close();
                return packet3;
            }
            if (packetId != null) {
                packet.setUniqueId(packetId);
            }
        }
        catch (IOException e) {
            Essential.logger.error("Error when reading byte buffer data '{}'.", (Object)array, (Object)e);
            return null;
        }
        if (!(packet instanceof ConnectionRegisterPacketTypeIdPacket)) return packet;
        ConnectionRegisterPacketTypeIdPacket p = (ConnectionRegisterPacketTypeIdPacket)packet;
        this.incomingPacketTypeIds.put(p.getPacketId(), p.getClassName());
        return null;
    }

    public void encode(Packet packet, Consumer<byte[]> send2) {
        byte[] packetIdBytes;
        int packetTypeId = this.outgoingPacketTypeIds.computeIfAbsent(this.splitPacketPackage(packet.getClass()), packetName -> {
            int newId = this.packetTypeId.incrementAndGet();
            this.encode(new ConnectionRegisterPacketTypeIdPacket((String)packetName, newId), send2);
            return newId;
        });
        UUID packetId = packet.getPacketUniqueId();
        byte[] packetBytes = gson.toJson(packet).getBytes(StandardCharsets.UTF_8);
        byte[] byArray = packetIdBytes = packetId != null ? packetId.toString().getBytes(StandardCharsets.UTF_8) : EMPTY_BYTE_ARRAY;
        if (LOG_PACKETS) {
            Essential.debug.info(packetId + " - " + packet.getClass().getSimpleName() + " " + new String(packetBytes));
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeInt(packetTypeId);
            dataOutputStream.writeInt(packetIdBytes.length);
            dataOutputStream.write(packetIdBytes);
            dataOutputStream.writeInt(packetBytes.length);
            dataOutputStream.write(packetBytes);
            send2.accept(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            Essential.logger.error("Error occurred when sending out packet '{}'.", (Object)packet, (Object)e);
        }
    }

    @NotNull
    private String readString(@NotNull DataInputStream dataInputStream) throws IOException {
        byte[] bytes = new byte[dataInputStream.readInt()];
        dataInputStream.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @NotNull
    private String splitPacketPackage(@NotNull Class<? extends Packet> packetClass) {
        return packetClass.getName().replace(PACKET_PACKAGE, "");
    }
}

