/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.backend.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec4;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.model.ParticleEffect;
import gg.essential.model.ParticleSystem;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.file.ParticlesFile;
import gg.essential.model.light.Light;
import gg.essential.model.util.Color;
import gg.essential.model.util.KotglKt;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import gg.essential.universal.vertex.UVertexConsumer;
import gg.essential.util.HelpersKt;
import gg.essential.util.OptiFineAccessor;
import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007#$%&'()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0019J \u0010\u001d\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0004\b\u001d\u0010\u001eR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!\u00a8\u0006*"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend;", "Lgg/essential/model/backend/RenderBackend;", "<init>", "()V", "Lgg/essential/model/backend/RenderBackend$Texture;", "dst", "", "Lgg/essential/model/backend/RenderBackend$BlitOp;", "ops", "", "blitTexture", "(Lgg/essential/model/backend/RenderBackend$Texture;Ljava/lang/Iterable;)V", "", "name", "", "width", "height", "createTexture", "(Ljava/lang/String;II)Lgg/essential/model/backend/RenderBackend$Texture;", "texture", "deleteTexture", "(Lgg/essential/model/backend/RenderBackend$Texture;)V", "Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/client/renderer/RenderType;", "getEmissiveArmorLayer", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;", "getEmissiveLayer", "", "bytes", "readTexture", "(Ljava/lang/String;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "armorLayers", "Ljava/util/Map;", "emissiveLayers", "CapeTexture", "CosmeticTexture", "DynamicTexture", "MinecraftTexture", "ParticleVertexConsumerProvider", "SkinTexture", "VertexConsumerProvider", "Essential 1.18.2-forge"})
@SourceDebugExtension(value={"SMAP\nMinecraftRenderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,433:1\n372#2,7:434\n372#2,7:441\n*S KotlinDebug\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend\n*L\n140#1:434,7\n177#1:441,7\n*E\n"})
public final class MinecraftRenderBackend
implements RenderBackend {
    @NotNull
    public static final MinecraftRenderBackend INSTANCE = new MinecraftRenderBackend();
    @NotNull
    private static final Map<ResourceLocation, RenderType> emissiveLayers = new LinkedHashMap();
    @NotNull
    private static final Map<ResourceLocation, RenderType> armorLayers = new LinkedHashMap();

    private MinecraftRenderBackend() {
    }

    @Override
    @NotNull
    public RenderBackend.Texture createTexture(@NotNull String name2, int width2, int height2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new DynamicTexture(HelpersKt.identifier("essential", name2), new ReleasedDynamicTexture(width2, height2));
    }

    @Override
    public void deleteTexture(@NotNull RenderBackend.Texture texture) {
        ReleasedDynamicTexture registeredTexture;
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        ResourceLocation identifier2 = ((DynamicTexture)texture).getIdentifier();
        ((DynamicTexture)texture).getTexture().m_117964_();
        TextureManager textureManager = UMinecraft.getMinecraft().f_90987_;
        AbstractTexture abstractTexture = textureManager.m_174786_(identifier2, null);
        ReleasedDynamicTexture releasedDynamicTexture = registeredTexture = abstractTexture instanceof ReleasedDynamicTexture ? (ReleasedDynamicTexture)abstractTexture : null;
        if (Intrinsics.areEqual((Object)((Object)registeredTexture), (Object)((Object)((DynamicTexture)texture).getTexture()))) {
            textureManager.m_118513_(identifier2);
        }
    }

    @Override
    public void blitTexture(@NotNull RenderBackend.Texture dst, @NotNull Iterable<RenderBackend.BlitOp> ops) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        TextureManager textureManager = UMinecraft.getMinecraft().f_90987_;
        boolean prevScissor = GL11.glGetBoolean((int)3089);
        if (prevScissor) {
            GL11.glDisable((int)3089);
        }
        int prevDrawFrameBufferBinding = GL11.glGetInteger((int)36006);
        int prevReadFrameBufferBinding = GL11.glGetInteger((int)36010);
        int dstBuffer = GL30.glGenFramebuffers();
        int srcBuffer = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36009, (int)dstBuffer);
        GL30.glBindFramebuffer((int)36008, (int)srcBuffer);
        GL30.glFramebufferTexture2D((int)36009, (int)36064, (int)3553, (int)MinecraftRenderBackend.blitTexture$glId(dst, textureManager), (int)0);
        for (RenderBackend.BlitOp blitOp : ops) {
            RenderBackend.Texture src = blitOp.component1();
            int srcX = blitOp.component2();
            int srcY = blitOp.component3();
            int destX = blitOp.component4();
            int destY = blitOp.component5();
            int width2 = blitOp.component6();
            int height2 = blitOp.component7();
            GL30.glFramebufferTexture2D((int)36008, (int)36064, (int)3553, (int)MinecraftRenderBackend.blitTexture$glId(src, textureManager), (int)0);
            GL30.glBlitFramebuffer((int)srcX, (int)srcY, (int)(srcX + width2), (int)(srcY + height2), (int)destX, (int)destY, (int)(destX + width2), (int)(destY + height2), (int)16384, (int)9728);
        }
        GL30.glBindFramebuffer((int)36009, (int)prevDrawFrameBufferBinding);
        GL30.glBindFramebuffer((int)36008, (int)prevReadFrameBufferBinding);
        GL30.glDeleteFramebuffers((int)dstBuffer);
        GL30.glDeleteFramebuffers((int)srcBuffer);
        if (prevScissor) {
            GL11.glEnable((int)3089);
        }
    }

    @NotNull
    public final RenderType getEmissiveLayer(@NotNull ResourceLocation texture) {
        RenderType renderType;
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Map<ResourceLocation, RenderType> $this$getOrPut$iv = emissiveLayers;
        boolean $i$f$getOrPut = false;
        RenderType value$iv = $this$getOrPut$iv.get(texture);
        if (value$iv == null) {
            boolean bl = false;
            RenderType inner = RenderType.m_110488_((ResourceLocation)texture);
            OptiFineAccessor of2 = OptiFineAccessor.Companion.getINSTANCE();
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.getEmissiveLayer.1.EmissiveLayer", "Lnet/minecraft/client/renderer/RenderType;", "<init>", "(Lnet/minecraft/client/renderer/RenderType;Lgg/essential/util/OptiFineAccessor;)V", "Essential 1.18.2-forge"})
            public final class EmissiveLayer
            extends RenderType {
                public EmissiveLayer(RenderType $inner, @Nullable OptiFineAccessor $of) {
                    super("entity_translucent_emissive_cull", $inner.m_110508_(), $inner.m_173186_(), $inner.m_110507_(), $inner.m_110405_(), true, () -> EmissiveLayer._init_$lambda$0($inner, $of), () -> EmissiveLayer._init_$lambda$1($of, $inner));
                }

                private static final void _init_$lambda$0(RenderType $inner, OptiFineAccessor $of) {
                    $inner.m_110185_();
                    RenderType.f_110139_.m_110185_();
                    if ($of != null && $of.Config_isShaders()) {
                        $of.Shaders_pushProgram();
                        $of.Shaders_beginSpiderEyes();
                    }
                }

                private static final void _init_$lambda$1(OptiFineAccessor $of, RenderType $inner) {
                    if ($of != null && $of.Config_isShaders()) {
                        $of.Shaders_endSpiderEyes();
                        $of.Shaders_popProgram();
                    }
                    RenderType.f_110139_.m_110188_();
                    $inner.m_110188_();
                }
            }
            RenderType answer$iv = new EmissiveLayer(inner, of2);
            $this$getOrPut$iv.put(texture, answer$iv);
            renderType = answer$iv;
        } else {
            renderType = value$iv;
        }
        return renderType;
    }

    @NotNull
    public final RenderType getEmissiveArmorLayer(@NotNull ResourceLocation texture) {
        RenderType renderType;
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Map<ResourceLocation, RenderType> $this$getOrPut$iv = armorLayers;
        boolean $i$f$getOrPut = false;
        RenderType value$iv = $this$getOrPut$iv.get(texture);
        if (value$iv == null) {
            boolean bl = false;
            RenderType inner = INSTANCE.getEmissiveLayer(texture);
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.getEmissiveArmorLayer.1.EmissiveArmorLayer", "Lnet/minecraft/client/renderer/RenderType;", "<init>", "(Lnet/minecraft/client/renderer/RenderType;)V", "Essential 1.18.2-forge"})
            public final class EmissiveArmorLayer
            extends RenderType {
                public EmissiveArmorLayer(@NotNull RenderType $inner) {
                    Intrinsics.checkNotNullParameter((Object)$inner, (String)"$inner");
                    super("armor_translucent_emissive", $inner.m_110508_(), $inner.m_173186_(), $inner.m_110507_(), $inner.m_110405_(), true, () -> EmissiveArmorLayer._init_$lambda$0($inner), () -> EmissiveArmorLayer._init_$lambda$1($inner));
                }

                private static final void _init_$lambda$0(RenderType $inner) {
                    Intrinsics.checkNotNullParameter((Object)$inner, (String)"$inner");
                    $inner.m_110185_();
                    RenderType.f_110119_.m_110185_();
                }

                private static final void _init_$lambda$1(RenderType $inner) {
                    Intrinsics.checkNotNullParameter((Object)$inner, (String)"$inner");
                    RenderType.f_110119_.m_110188_();
                    $inner.m_110188_();
                }
            }
            RenderType answer$iv = new EmissiveArmorLayer(inner);
            $this$getOrPut$iv.put(texture, answer$iv);
            renderType = answer$iv;
        } else {
            renderType = value$iv;
        }
        return renderType;
    }

    @Override
    @Nullable
    public Object readTexture(@NotNull String name2, @NotNull byte[] bytes, @NotNull Continuation<? super RenderBackend.Texture> $completion) {
        ReleasedDynamicTexture releasedDynamicTexture = UGraphics.getTexture(new ByteArrayInputStream(bytes));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)releasedDynamicTexture), (String)"getTexture(...)");
        return new CosmeticTexture(name2, releasedDynamicTexture);
    }

    private static final int blitTexture$glId(RenderBackend.Texture $this$blitTexture_u24glId, TextureManager textureManager) {
        Intrinsics.checkNotNull((Object)$this$blitTexture_u24glId, (String)"null cannot be cast to non-null type gg.essential.model.backend.minecraft.MinecraftRenderBackend.MinecraftTexture");
        AbstractTexture abstractTexture = textureManager.m_118506_(((MinecraftTexture)$this$blitTexture_u24glId).getIdentifier());
        Intrinsics.checkNotNull((Object)abstractTexture);
        return abstractTexture.m_117963_();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$CapeTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "component1", "()Lnet/minecraft/resources/ResourceLocation;", "copy", "(Lnet/minecraft/resources/ResourceLocation;)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$CapeTexture;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "getHeight", "height", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "getWidth", "width", "Essential 1.18.2-forge"})
    public static final class CapeTexture
    implements MinecraftTexture {
        @NotNull
        private final ResourceLocation identifier;

        public CapeTexture(@NotNull ResourceLocation identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            this.identifier = identifier2;
        }

        @Override
        @NotNull
        public ResourceLocation getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getWidth() {
            return 64;
        }

        @Override
        public int getHeight() {
            return 32;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.identifier;
        }

        @NotNull
        public final CapeTexture copy(@NotNull ResourceLocation identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            return new CapeTexture(identifier2);
        }

        public static /* synthetic */ CapeTexture copy$default(CapeTexture capeTexture, ResourceLocation resourceLocation, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = capeTexture.identifier;
            }
            return capeTexture.copy(resourceLocation);
        }

        @NotNull
        public String toString() {
            return "CapeTexture(identifier=" + this.identifier + ")";
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CapeTexture)) {
                return false;
            }
            CapeTexture capeTexture = (CapeTexture)other;
            return Intrinsics.areEqual((Object)this.identifier, (Object)capeTexture.identifier);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$CosmeticTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$DynamicTexture;", "", "name", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "texture", "<init>", "(Ljava/lang/String;Lgg/essential/universal/utils/ReleasedDynamicTexture;)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Essential 1.18.2-forge"})
    public static final class CosmeticTexture
    extends DynamicTexture {
        @NotNull
        private final String name;

        public CosmeticTexture(@NotNull String name2, @NotNull ReleasedDynamicTexture texture) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)texture), (String)"texture");
            String string = name2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            super(HelpersKt.identifier("essential", "textures/cosmetics/" + string), texture);
            this.name = name2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u0003\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u0016"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$DynamicTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "texture", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lgg/essential/universal/utils/ReleasedDynamicTexture;)V", "", "height", "I", "getHeight", "()I", "identifier$delegate", "Lkotlin/Lazy;", "getIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "getTexture", "()Lgg/essential/universal/utils/ReleasedDynamicTexture;", "width", "getWidth", "Essential 1.18.2-forge"})
    public static class DynamicTexture
    implements MinecraftTexture {
        @NotNull
        private final ReleasedDynamicTexture texture;
        private final int width;
        private final int height;
        @NotNull
        private final Lazy identifier$delegate;

        public DynamicTexture(@NotNull ResourceLocation identifier2, @NotNull ReleasedDynamicTexture texture) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)((Object)texture), (String)"texture");
            this.texture = texture;
            this.width = this.texture.getWidth();
            this.height = this.texture.getHeight();
            this.identifier$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResourceLocation>(identifier2, this){
                final /* synthetic */ ResourceLocation $identifier;
                final /* synthetic */ DynamicTexture this$0;
                {
                    this.$identifier = $identifier;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final ResourceLocation invoke() {
                    TextureManager textureManager = UMinecraft.getMinecraft().f_90987_;
                    AbstractTexture abstractTexture = textureManager.m_174786_(this.$identifier, null);
                    ReleasedDynamicTexture releasedDynamicTexture = abstractTexture instanceof ReleasedDynamicTexture ? (ReleasedDynamicTexture)abstractTexture : null;
                    if (releasedDynamicTexture != null) {
                        releasedDynamicTexture.m_117964_();
                    }
                    textureManager.m_118495_(this.$identifier, (AbstractTexture)this.this$0.getTexture());
                    return this.$identifier;
                }
            }));
        }

        @NotNull
        public final ReleasedDynamicTexture getTexture() {
            return this.texture;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        @NotNull
        public ResourceLocation getIdentifier() {
            Lazy lazy2 = this.identifier$delegate;
            return (ResourceLocation)lazy2.getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0005\u001a\u00020\u00028&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lgg/essential/model/backend/RenderBackend$Texture;", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "identifier", "Essential 1.18.2-forge"})
    public static interface MinecraftTexture
    extends RenderBackend.Texture {
        @NotNull
        public ResourceLocation getIdentifier();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider;", "Lgg/essential/model/ParticleSystem$VertexConsumerProvider;", "<init>", "()V", "Lgg/essential/model/ParticleEffect$RenderPass;", "renderPass", "Lkotlin/Function1;", "Lgg/essential/model/util/UVertexConsumer;", "", "block", "provide", "(Lgg/essential/model/ParticleEffect$RenderPass;Lkotlin/jvm/functions/Function1;)V", "Essential 1.18.2-forge"})
    public static final class ParticleVertexConsumerProvider
    implements ParticleSystem.VertexConsumerProvider {
        @Override
        public void provide(@NotNull ParticleEffect.RenderPass renderPass, @NotNull Function1<? super gg.essential.model.util.UVertexConsumer, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)renderPass, (String)"renderPass");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            RenderBackend.Texture texture = renderPass.getTexture();
            if (!(texture instanceof MinecraftTexture)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BlendState prevBlend = BlendState.Companion.active();
            int prevTextureId = GL11.glGetInteger((int)32873);
            boolean prevCull = GL11.glIsEnabled((int)2884);
            (switch (WhenMappings.$EnumSwitchMapping$0[renderPass.getMaterial().ordinal()]) {
                case 1 -> new BlendState(BlendState.Equation.ADD, BlendState.Param.SRC_ALPHA, BlendState.Param.ONE, null, null, false, 56, null);
                case 2 -> BlendState.DISABLED;
                case 3 -> BlendState.NORMAL;
                default -> throw new NoWhenBranchMatchedException();
            }).activate();
            UGraphics.bindTexture(0, ((MinecraftTexture)texture).getIdentifier());
            if (!prevCull) {
                RenderSystem.m_69481_();
            }
            UGraphics renderer = UGraphics.getFromTessellator();
            renderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, DefaultVertexFormat.f_85813_);
            UVertexConsumer uVertexConsumer = renderer.asUVertexConsumer();
            Intrinsics.checkNotNullExpressionValue((Object)uVertexConsumer, (String)"asUVertexConsumer(...)");
            /*
             * Illegal identifiers - consider using --renameillegalidents true
             */
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\r\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\tJ/\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.ParticleVertexConsumerProvider.provide.VertexConsumerAdapter", "Lgg/essential/model/util/UVertexConsumer;", "Lgg/essential/universal/vertex/UVertexConsumer;", "inner", "<init>", "(Lgg/essential/universal/vertex/UVertexConsumer;)V", "Lgg/essential/model/util/Color;", "color", "color-EIFkdBU", "(I)Lgg/essential/model/util/UVertexConsumer;", "endVertex", "()Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/model/light/Light;", "light", "light-vX8ayIk", "Lgg/essential/model/util/UMatrixStack;", "stack", "", "x", "y", "z", "norm", "(Lgg/essential/model/util/UMatrixStack;FFF)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "", "pos", "(Lgg/essential/model/util/UMatrixStack;DDD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "u", "v", "tex", "(DD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/universal/vertex/UVertexConsumer;", "Essential 1.18.2-forge"})
            @SourceDebugExtension(value={"SMAP\nMinecraftRenderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,433:1\n1#2:434\n*E\n"})
            public final class VertexConsumerAdapter
            implements gg.essential.model.util.UVertexConsumer {
                @NotNull
                private final UVertexConsumer inner;

                public VertexConsumerAdapter(@NotNull UVertexConsumer inner) {
                    Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
                    this.inner = inner;
                }

                @NotNull
                public VertexConsumerAdapter pos(@NotNull gg.essential.model.util.UMatrixStack stack, double x, double y, double z) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    VertexConsumerAdapter $this$pos_u24lambda_u240 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    MutableVec4 vec = MutableVectors.mutableVec4((float)x, (float)y, (float)z, 1.0f);
                    KotglKt.timesSelf(vec, stack.peek().getModel());
                    $this$pos_u24lambda_u240.inner.pos(UMatrixStack.UNIT, vec.getX(), vec.getY(), vec.getZ());
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter tex(double u, double v) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$tex_u24lambda_u241 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$tex_u24lambda_u241.inner.tex(u, v);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter norm(@NotNull gg.essential.model.util.UMatrixStack stack, float x, float y, float z) {
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    return this;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer color-EIFkdBU(int color2) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$color_EIFkdBU_u24lambda_u243 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    int $this$color_EIFkdBU_u24lambda_u243_u24lambda_u242 = color2;
                    boolean bl2 = false;
                    $this$color_EIFkdBU_u24lambda_u243.inner.color(Color.getR-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF, Color.getG-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF, Color.getB-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF, Color.getA-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer light-vX8ayIk(int light) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$light_vX8ayIk_u24lambda_u244 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$light_vX8ayIk_u24lambda_u244.inner.light(Light.getBlockLight-Mh2AYeg(light) & 0xFFFF, Light.getSkyLight-Mh2AYeg(light) & 0xFFFF);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter endVertex() {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$endVertex_u24lambda_u245 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$endVertex_u24lambda_u245.inner.endVertex();
                    return vertexConsumerAdapter;
                }
            }
            block.invoke((Object)new VertexConsumerAdapter(uVertexConsumer));
            renderer.drawDirect();
            if (!prevCull) {
                RenderSystem.m_69464_();
            }
            UGraphics.bindTexture(0, prevTextureId);
            prevBlend.activate();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ParticlesFile.Material.values().length];
                try {
                    nArray[ParticlesFile.Material.Add.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticlesFile.Material.Cutout.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticlesFile.Material.Blend.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$SkinTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "component1", "()Lnet/minecraft/resources/ResourceLocation;", "copy", "(Lnet/minecraft/resources/ResourceLocation;)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$SkinTexture;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "getHeight", "height", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "getWidth", "width", "Essential 1.18.2-forge"})
    public static final class SkinTexture
    implements MinecraftTexture {
        @NotNull
        private final ResourceLocation identifier;

        public SkinTexture(@NotNull ResourceLocation identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            this.identifier = identifier2;
        }

        @Override
        @NotNull
        public ResourceLocation getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getWidth() {
            return 64;
        }

        @Override
        public int getHeight() {
            return 64;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.identifier;
        }

        @NotNull
        public final SkinTexture copy(@NotNull ResourceLocation identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            return new SkinTexture(identifier2);
        }

        public static /* synthetic */ SkinTexture copy$default(SkinTexture skinTexture, ResourceLocation resourceLocation, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = skinTexture.identifier;
            }
            return skinTexture.copy(resourceLocation);
        }

        @NotNull
        public String toString() {
            return "SkinTexture(identifier=" + this.identifier + ")";
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SkinTexture)) {
                return false;
            }
            SkinTexture skinTexture = (SkinTexture)other;
            return Intrinsics.areEqual((Object)this.identifier, (Object)skinTexture.identifier);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider;", "Lgg/essential/model/backend/RenderBackend$VertexConsumerProvider;", "Lnet/minecraft/client/renderer/MultiBufferSource;", "provider", "", "light", "<init>", "(Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "Lgg/essential/model/backend/RenderBackend$Texture;", "texture", "", "emissive", "Lkotlin/Function1;", "Lgg/essential/model/util/UVertexConsumer;", "", "block", "provide", "(Lgg/essential/model/backend/RenderBackend$Texture;ZLkotlin/jvm/functions/Function1;)V", "I", "getLight", "()I", "Lnet/minecraft/client/renderer/MultiBufferSource;", "getProvider", "()Lnet/minecraft/client/renderer/MultiBufferSource;", "Essential 1.18.2-forge"})
    public static final class VertexConsumerProvider
    implements RenderBackend.VertexConsumerProvider {
        @NotNull
        private final MultiBufferSource provider;
        private final int light;

        public VertexConsumerProvider(@NotNull MultiBufferSource provider2, int light) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            this.provider = provider2;
            this.light = light;
        }

        @NotNull
        public final MultiBufferSource getProvider() {
            return this.provider;
        }

        public final int getLight() {
            return this.light;
        }

        @Override
        public void provide(@NotNull RenderBackend.Texture texture, boolean emissive, @NotNull Function1<? super gg.essential.model.util.UVertexConsumer, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            if (!(texture instanceof MinecraftTexture)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            VertexConsumer buffer = this.provider.m_6299_(emissive ? INSTANCE.getEmissiveLayer(((MinecraftTexture)texture).getIdentifier()) : RenderType.m_110470_((ResourceLocation)((MinecraftTexture)texture).getIdentifier()));
            Intrinsics.checkNotNull((Object)buffer);
            /*
             * Illegal identifiers - consider using --renameillegalidents true
             */
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\r\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\tJ/\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.VertexConsumerProvider.provide.VertexConsumerAdapter", "Lgg/essential/model/util/UVertexConsumer;", "Lgg/essential/universal/vertex/UVertexConsumer;", "inner", "<init>", "(Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider;Lgg/essential/universal/vertex/UVertexConsumer;)V", "Lgg/essential/model/util/Color;", "color", "color-EIFkdBU", "(I)Lgg/essential/model/util/UVertexConsumer;", "endVertex", "()Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/model/light/Light;", "light", "light-vX8ayIk", "Lgg/essential/model/util/UMatrixStack;", "stack", "", "x", "y", "z", "norm", "(Lgg/essential/model/util/UMatrixStack;FFF)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "", "pos", "(Lgg/essential/model/util/UMatrixStack;DDD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "u", "v", "tex", "(DD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/universal/vertex/UVertexConsumer;", "Essential 1.18.2-forge"})
            @SourceDebugExtension(value={"SMAP\nMinecraftRenderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,433:1\n1#2:434\n*E\n"})
            public final class VertexConsumerAdapter
            implements gg.essential.model.util.UVertexConsumer {
                @NotNull
                private final UVertexConsumer inner;
                final /* synthetic */ VertexConsumerProvider this$0;

                public VertexConsumerAdapter(@NotNull VertexConsumerProvider $receiver, @NotNull UVertexConsumer inner) {
                    Intrinsics.checkNotNullParameter((Object)$receiver, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
                    this.this$0 = $receiver;
                    this.inner = inner;
                }

                @NotNull
                public VertexConsumerAdapter pos(@NotNull gg.essential.model.util.UMatrixStack stack, double x, double y, double z) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    VertexConsumerAdapter $this$pos_u24lambda_u240 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    MutableVec4 vec = MutableVectors.mutableVec4((float)x, (float)y, (float)z, 1.0f);
                    KotglKt.timesSelf(vec, stack.peek().getModel());
                    $this$pos_u24lambda_u240.inner.pos(UMatrixStack.UNIT, vec.getX(), vec.getY(), vec.getZ());
                    $this$pos_u24lambda_u240.inner.color(1.0f, 1.0f, 1.0f, 1.0f);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter tex(double u, double v) {
                    VertexConsumerAdapter vertexConsumerAdapter = this;
                    VertexConsumerProvider vertexConsumerProvider = this.this$0;
                    VertexConsumerAdapter $this$tex_u24lambda_u241 = vertexConsumerAdapter;
                    boolean bl = false;
                    $this$tex_u24lambda_u241.inner.tex(u, v);
                    $this$tex_u24lambda_u241.inner.overlay(OverlayTexture.m_118088_((float)0.0f), OverlayTexture.m_118096_((boolean)false));
                    $this$tex_u24lambda_u241.inner.light(vertexConsumerProvider.getLight() & 0xFFFF, vertexConsumerProvider.getLight() >> 16 & 0xFFFF);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter norm(@NotNull gg.essential.model.util.UMatrixStack stack, float x, float y, float z) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    VertexConsumerAdapter $this$norm_u24lambda_u242 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    MutableVec3 vec = MutableVectors.mutableVec3(x, y, z);
                    KotglKt.timesSelf(vec, stack.peek().getNormal());
                    $this$norm_u24lambda_u242.inner.norm(UMatrixStack.UNIT, vec.getX(), vec.getY(), vec.getZ());
                    return vertexConsumerAdapter;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer color-EIFkdBU(int color2) {
                    return this;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer light-vX8ayIk(int light) {
                    return this;
                }

                @NotNull
                public VertexConsumerAdapter endVertex() {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$endVertex_u24lambda_u243 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$endVertex_u24lambda_u243.inner.endVertex();
                    return vertexConsumerAdapter;
                }
            }
            block.invoke((Object)new VertexConsumerAdapter(this, UVertexConsumer.Companion.of(buffer)));
        }
    }
}

