/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 :2\u00020\u0001:\u0001:B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\u0006\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\b2\b\b\u0002\u0010\u0006\u001a\u00020\bH\u00c6\u0001J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0000J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001e\u001a\u00020\u0000J\u0011\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0086\u0002J\t\u0010\"\u001a\u00020!H\u00d6\u0001J\u0006\u0010#\u001a\u00020\bJ\u0016\u0010$\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0011\u0010(\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000J\u0019\u00102\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u00103\u001a\u00020\bH\u0086\u0002J\u001e\u00102\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u00104\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\bJ\u000e\u00105\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0004J\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0016\u00107\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\t\u00108\u001a\u000209H\u00d6\u0001R\u0012\u0010\u0003\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lgg/essential/model/Vector3;", "", "()V", "x", "", "y", "z", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "(FFF)V", "add", "v", "addScalar", "s", "addVectors", "a", "b", "ceil", "clone", "component1", "component2", "component3", "copy", "cross", "crossVectors", "divideScalar", "dot", "equals", "", "other", "floor", "get", "index", "", "hashCode", "length", "lerp", "alpha", "max", "min", "minus", "multiply", "multiplyScalar", "negate", "negateY", "normalize", "plus", "reflect", "normal", "round", "set", "value", "setLength", "setScalar", "sub", "subVectors", "toString", "", "Companion", "cosmetics"})
public final class Vector3 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public float x;
    @JvmField
    public float y;
    @JvmField
    public float z;
    @JvmField
    @NotNull
    public static final Vector3 X = new Vector3(1.0f, 0.0f, 0.0f);
    @JvmField
    @NotNull
    public static final Vector3 Y = new Vector3(0.0f, 1.0f, 0.0f);
    @JvmField
    @NotNull
    public static final Vector3 Z = new Vector3(0.0f, 0.0f, 1.0f);

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        this(x.floatValue(), y.floatValue(), z.floatValue());
    }

    @NotNull
    public final Vector3 set(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        this.x = x.floatValue();
        this.y = y.floatValue();
        this.z = z.floatValue();
        return this;
    }

    @NotNull
    public final Vector3 setScalar(@NotNull Number s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.set(s, s, s);
    }

    @NotNull
    public final Vector3 set(int index2, float value2) {
        switch (index2) {
            case 0: {
                this.x = value2;
                break;
            }
            case 1: {
                this.y = value2;
                break;
            }
            case 2: {
                this.z = value2;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public final float get(int index2) {
        float f;
        switch (index2) {
            case 0: {
                f = this.x;
                break;
            }
            case 1: {
                f = this.y;
                break;
            }
            case 2: {
                f = this.z;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return f;
    }

    @NotNull
    public final Vector3 clone() {
        return Vector3.copy$default(this, 0.0f, 0.0f, 0.0f, 7, null);
    }

    @NotNull
    public final Vector3 copy(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.set(Float.valueOf(v.x), Float.valueOf(v.y), Float.valueOf(v.z));
    }

    @NotNull
    public final Vector3 add(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    @NotNull
    public final Vector3 addScalar(float s) {
        this.x += s;
        this.y += s;
        this.z += s;
        return this;
    }

    @NotNull
    public final Vector3 addVectors(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        this.z = a.z + b.z;
        return this;
    }

    @NotNull
    public final Vector3 sub(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    @NotNull
    public final Vector3 subVectors(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
        return this;
    }

    @NotNull
    public final Vector3 multiply(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    @NotNull
    public final Vector3 multiplyScalar(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    @NotNull
    public final Vector3 divideScalar(float s) {
        return this.multiplyScalar(1.0f / s);
    }

    @NotNull
    public final Vector3 min(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        this.z = Math.min(this.z, v.z);
        return this;
    }

    @NotNull
    public final Vector3 max(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        this.z = Math.max(this.z, v.z);
        return this;
    }

    @NotNull
    public final Vector3 floor() {
        this.x = (float)Math.floor(this.x);
        this.y = (float)Math.floor(this.y);
        this.z = (float)Math.floor(this.z);
        return this;
    }

    @NotNull
    public final Vector3 ceil() {
        this.x = (float)Math.ceil(this.x);
        this.y = (float)Math.ceil(this.y);
        this.z = (float)Math.ceil(this.z);
        return this;
    }

    @NotNull
    public final Vector3 round() {
        this.x = MathKt.roundToInt((float)this.x);
        this.y = MathKt.roundToInt((float)this.y);
        this.z = MathKt.roundToInt((float)this.z);
        return this;
    }

    @NotNull
    public final Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @NotNull
    public final Vector3 negateY() {
        this.y = -this.y;
        return this;
    }

    public final float dot(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @NotNull
    public final Vector3 normalize() {
        float length = this.length();
        if (Float.isNaN(length)) {
            length = 1.0f;
        }
        return this.divideScalar(length);
    }

    @NotNull
    public final Vector3 setLength(float length) {
        return this.normalize().multiplyScalar(length);
    }

    @NotNull
    public final Vector3 lerp(@NotNull Vector3 v, float alpha) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.x += (v.x - this.x) * alpha;
        this.y += (v.y - this.y) * alpha;
        this.z += (v.z - this.z) * alpha;
        return this;
    }

    @NotNull
    public final Vector3 cross(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.crossVectors(this, v);
    }

    @NotNull
    public final Vector3 crossVectors(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        float ax = a.x;
        float ay = a.y;
        float az = a.z;
        float bx = b.x;
        float by = b.y;
        float bz = b.z;
        this.x = ay * bz - az * by;
        this.y = az * bx - ax * bz;
        this.z = ax * by - ay * bx;
        return this;
    }

    @NotNull
    public final Vector3 reflect(@NotNull Vector3 normal) {
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        Vector3 v1 = new Vector3();
        return this.sub(v1.copy(normal).multiplyScalar((float)2 * this.dot(normal)));
    }

    @NotNull
    public final Vector3 plus(@NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Vector3.copy$default(this, 0.0f, 0.0f, 0.0f, 7, null).add(b);
    }

    @NotNull
    public final Vector3 minus(@NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Vector3.copy$default(this, 0.0f, 0.0f, 0.0f, 7, null).sub(b);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    @NotNull
    public final Vector3 copy(float x, float y, float z) {
        return new Vector3(x, y, z);
    }

    public static /* synthetic */ Vector3 copy$default(Vector3 vector3, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = vector3.x;
        }
        if ((n & 2) != 0) {
            f2 = vector3.y;
        }
        if ((n & 4) != 0) {
            f3 = vector3.z;
        }
        return vector3.copy(f, f2, f3);
    }

    @NotNull
    public String toString() {
        return "Vector3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = result * 31 + Float.hashCode(this.y);
        result = result * 31 + Float.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3)) {
            return false;
        }
        Vector3 vector3 = (Vector3)other;
        if (Float.compare(this.x, vector3.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, vector3.y) != 0) {
            return false;
        }
        return Float.compare(this.z, vector3.z) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgg/essential/model/Vector3$Companion;", "", "()V", "X", "Lgg/essential/model/Vector3;", "Y", "Z", "cosmetics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

