/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.sps;

import gg.essential.Essential;
import gg.essential.network.connectionmanager.ice.IIceManager;
import gg.essential.sps.quic.jvm.UtilKt;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.util.HttpUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={HttpUtil.class})
public class Mixin_ResolveSpsResourcePackUrl {
    @ModifyVariable(method={"downloadTo"}, at=@At(value="HEAD"), argsOnly=true)
    private static String resolveSpsUrl(String str) throws MalformedURLException {
        URL url = new URL(str);
        URL resolvedUrl = Mixin_ResolveSpsResourcePackUrl.resolveSpsUrl(url);
        if (resolvedUrl == url) {
            return str;
        }
        return resolvedUrl.toString();
    }

    @Unique
    private static URL resolveSpsUrl(URL url) throws MalformedURLException {
        if (!url.getHost().endsWith(".essential-sps")) {
            return url;
        }
        IIceManager iceManager = Essential.getInstance().getConnectionManager().getIceManager();
        Integer proxyHttpPort = iceManager.getProxyHttpPort();
        if (proxyHttpPort == null) {
            Essential.logger.warn("Received resource pack url with SPS target but http proxy is not available: {}", (Object)url);
            return url;
        }
        return new URL(url.getProtocol(), UtilKt.getLOCALHOST().getHostAddress(), proxyHttpPort, url.getFile());
    }
}

