/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.ice.common.ice4j;

import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.stack.StunServerTransaction;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.ice4j.stack.TransactionID;
import gg.essential.lib.mixinextras.injector.ModifyReceiver;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StunStack.class}, remap=false)
public abstract class Mixin_FixIce4JDataRaceInStunRequestHandling {
    @Shadow
    @Final
    private static Logger logger;
    @Shadow
    @Final
    private Hashtable<TransactionID, StunServerTransaction> serverTransactions;
    @Unique
    private static final ThreadLocal<StunServerTransaction> newTransaction;

    @ModifyReceiver(method={"handleMessageEvent"}, at={@At(value="INVOKE", target="Lgg/essential/lib/ice4j/stack/StunServerTransaction;start()V")})
    private StunServerTransaction captureNewTransaction(StunServerTransaction transaction) {
        newTransaction.set(transaction);
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"handleMessageEvent"}, at={@At(value="INVOKE", target="Lgg/essential/lib/ice4j/stack/StunServerTransaction;start()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void checkForRace(StunMessageEvent ev, CallbackInfo ci) {
        StunServerTransaction transaction = newTransaction.get();
        newTransaction.set(null);
        Hashtable<TransactionID, StunServerTransaction> hashtable = this.serverTransactions;
        synchronized (hashtable) {
            StunServerTransaction existingTransaction = this.serverTransactions.get(ev.getTransactionID());
            if (existingTransaction == null) {
                this.serverTransactions.put(ev.getTransactionID(), transaction);
                return;
            }
            logger.finest("never mind that, found an existing transaction after all");
            try {
                StunServerTransaction.class.getDeclaredMethod("retransmitResponse", new Class[0]).invoke((Object)existingTransaction, new Object[0]);
                logger.finest("Response retransmitted");
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Failed to retransmit a stun response", ex);
            }
            ci.cancel();
        }
    }

    static {
        newTransaction = new ThreadLocal();
    }
}

