/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.ice.common.ice4j;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.mixins.impl.feature.ice.common.StunStackExt;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StunStack.class}, remap=false)
public abstract class Mixin_CloseRelayedAddressesFirst
implements StunStackExt {
    @Unique
    private final Queue<TransportAddress> relayedAddresses = new ConcurrentLinkedQueue<TransportAddress>();

    @Override
    public void rememberToCloseFirst(TransportAddress address) {
        this.relayedAddresses.add(address);
    }

    @Inject(method={"shutDown"}, at={@At(value="HEAD")})
    private void closeRelayedCandidatesFirst(CallbackInfo ci) {
        TransportAddress address;
        while ((address = this.relayedAddresses.poll()) != null) {
            this.removeSocket(address);
        }
    }

    @Shadow
    public abstract void removeSocket(TransportAddress var1);
}

